define('oxguard/files/util', [
    'oxguard/util',
    'settings!oxguard'
], function (coreUtil, settings) {
    'use strict';

    var util = _.extend({}, coreUtil);

    util.encryptedOnly = function encryptedOnly(list) {
        if (list === null) return (false);
        if (list instanceof Array) {
            return list.reduce(function (acc, file) {
                return acc && file.isEncrypted();
            }, true);
        } else return (list.isEncrypted());
    };

    util.hasEncrypted = function hasEncryptd(list) {
        if (list === null) return (false);
        if (list instanceof Array) {
            var encrypted = false;
            list.forEach(function (file) {
                if (file.isEncrypted()) encrypted = true;
            });
            return (encrypted);
        } else return (list.isEncrypted());
    };

    util.isNotAttachment = function isNotAttachment(list) {
        if (list === null) return (false);
        if (list instanceof Array) {
            return list.reduce(function (acc, file) {
                return acc && (file.pgpFormat === undefined);
            }, true);
        } else return (list.get('pgpFormat') === undefined);
    };

    util.isMailvelope = function isMailvelope() {
        return (settings.get('cryptoProvider') === 'mailvelope');
    };

    return util;
});
