/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */

define('oxguard/files/downloader', [
    'gettext!oxguard',
    'oxguard/core/og_http'
], function (gt) {
    // Download a file to browser or as download

    function getFile(list, action, auth, extrapass, popup)
    {
        list.map(function (file) {
            if (file.filename.indexOf('.grd') > 0 || (file.filename.indexOf('.pgp')) > 0 || (file.source === 'guard')) {// Make sure OxGuard file
                var params = '&id=' + file.id +
                    '&folder=' + file.folder_id +
                    '&session=' + ox.session +
                    '&auth=' + encodeURIComponent(auth) +
                    '&userid=' + ox.user_id +
                    '&cid=' + ox.context_id +
                    (file.version ? ('&version=' + file.version) : '') +
                    '&download=' + (action === 'download') +
                    '&language=' + ox.language +
                    '&filename=' + (file.origName === undefined ? encodeURIComponent(file.filename) : encodeURIComponent(file.origName));

                if (extrapass !== undefined) params = params + '&encrextra=' +  encodeURIComponent(extrapass);

                var link = ox.apiRoot + '/oxguard/file/' + encodeURIComponent(file.filename.replace('.grd2', '').replace('.grd', '').replace('.pgp','')) + '?action=get' + params;

                if (action === 'view') {
                    file.guardUrl = link;
                    file.source = 'guard';
                    file.origData = file;
                    file.origName = file.filename;
                    file.filename = file.filename.replace('.pgp', '').replace('.grd2','').replace('.grd','');
                    delete(file.mail);
                    ox.load(['io.ox/mail/actions/viewer']).done(function (action) {
                        action({ files: list });
                    });
                    return;
                }

                if (action === 'download') {
                    iframe(link, file.id);
                } else {
                    //Try opening in popup.
                    if (popup === null || popup === undefined) {
                        require (['io.ox/core/notifications'], function (notifications) {
                            //#. Error message when trying to open a file with popup blocker on browser blocking, %s is product name
                            notifications.yell('error', gt('Your pop-up blocker may have prevented a %s window that provides application functionality.', window.oxguarddata.productName));
                        });
                    } else {
                        popup.location.href = link;
                    }
                }
            }

        });
    }
    function iframe(url, fileid) {
        $('#tmp').append(
            $('<iframe>', { src: url, 'class': 'hidden download-frame', id: 'download' + fileid })
        );
    }

    return {
        getFile: getFile
    };
});
