/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */
define('oxguard/core/log', [
    'io.ox/core/http'
], function (http) {
    'use strict';

    function log (e, o) {
        var collection = http.log();
        collection.add(new Backbone.Model(e).set({
            params: o.params,
            data: o.data,
            index: collection.length,
            timestamp: _.now(),
            url: o.url
        }));
    }

    function fail (r, url, params, data) {
        var errorText = r.statusText;
        if (r.status === 406 || r.status == 500) {
            errorText = r.status + ': ' + errorText + ' - ' + r.responseText;
            r.status = undefined;
        }
        var e = {
            error: errorText,
            status: r.status
        };
        var o = {
            params: params,
            url: url,
            data: data
        };
        log (e, o);
    }

    function slow (took, url, params, data) {
        var e = { error: 'Took: ' + (Math.round(took / 100) / 10) + 's', status: 200, took: took };
        var o = {
            params: params,
            url: url,
            data: data
        };
        log (e, o);
    }

    return {
        fail: fail,
        slow: slow
    };
});
