define('mailvelope/view-detail', [
    'io.ox/core/extensions',
    'mailvelope/main',
    'io.ox/mail/api',
    'settings!oxguard'
], function (ext, mailvelope, mailAPI, settings) {
    'use strict';

    ext.point('oxguard/view/pgp/mail/encrypted').extend({
        id: 'mailvelope',
        requires: function () {
            return settings.get('cryptoProvider') === 'mailvelope';
        },
        draw: function (baton) {
            var cid = _.cid(baton.data);
            if (!cid) return;
            // insert Mailvelope div before current shadow Dom
            var loc = baton.view.$el.find('.body');
            loc.before('<div class="mail-item mail-detail content" data-cid="' + cid + '">');
            $(loc[0]).replaceWith('');  // Remove current DOM

            $('.mail-item.mail-detail[data-cid="' + cid + '"] .content').toggleClass('current', false);
            $('.mail-item.mail-detail[data-cid="' + cid + '"] .content:visible').toggleClass('current', true);
            // Draw inline from first attachment
            if (baton.data.PGPInline === true) {
                baton.stopPropagation();
                var text = baton.data.attachments[0].content.replace(/<br>/g, '\r\n');
                return renderMail(cid, text);
            }
            // Otherwise pull Mime data
            var data = _(baton.data.pgp_attachments).find(function (a) {
                return (/^application\/octet-stream/).test(a.content_type);
            });
            data.mail = baton.data;

            return $.ajax({ url: mailAPI.getUrl(data, 'view'), dataType: 'text' }).then(function (text) {
                return renderMail(cid, text);
            }).then(function () {
                baton.stopPropagation();
            });
        }
    });

    function renderMail(cid, text) {
        return mailvelope.createDisplayContainer('.mail-item.mail-detail[data-cid="' + cid + '"] .content.current', text)
            .done(function () {
                resize(cid);
            }).fail(function (err) {
                if (!err || err.code !== 'TIMEOUT') {
                    if (ox.debug) console.log(err);
                    return;
                }

                return require(['mailvelope/tour']).then(function (runTour) {
                    return runTour();
                }).then(function () {
                    return renderMail(cid, text);
                });
            });
    }

    function resize (cid) {
        try {
            var listitem = $('.mail-item.mail-detail[data-cid="' + cid + '"]').parent();
            listitem.css('height', '100%');
            var header = listitem.find('detail-view-header')[0];
            var iframe = $($('.mail-item.mail-detail[data-cid="' + cid + '"] .content.current').find('iframe')[0]);
            iframe.height($(listitem).height() - $(header).height());
        } catch (e) {
            console.log(e);
        }
    }
});
