/* All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016-2020 OX Software GmbH
 */

define('mailvelope/sync/syncobject', [
'oxguard/core/og_http',
'io.ox/core/extensions',
'gettext!oxguard'
], function (og_http, ext, gt) {
    'use strict';

    var syncHandlerObj = {
        /**
         * Upload the public keyring to the backend server
         * @param syncObj
         */
        uploadSync: function () {
            return new window.Promise(function (resolve) {
                resolve();
            });
        },

        /**
         * Download the public keyring from the backend server
         * @param syncObj
         */
        downloadSync: function () {
            return new window.Promise(function (resolve) {
                resolve();
            });
        },

        /**
         * Backup private key
         * @param syncObj
         */
        backup: function (syncObj) {
            var params = '&session=' + ox.session +
            '&userid=' + ox.user_id +
            '&cid=' + ox.context_id;
            var data = {
                data: syncObj.backup
            };
            return new window.Promise(function (resolve, reject) {
                og_http.post(ox.apiRoot + '/oxguard/mailvelope?action=backup', params, data)
                .done(function () {
                    resolve();
                })
                .fail(function (e) {
                    console.log(e.statusText);
                    reject(new Error(e.responseText));
                });
            });
        },

        /**
         * Restore private key backup
         */
        restore: function () {
            return new window.Promise(function (resolve, reject) {
                var params = '&session=' + ox.session +
                '&userid=' + ox.user_id +
                '&cid=' + ox.context_id;
                og_http.get(ox.apiRoot + '/oxguard/mailvelope?action=restore', params)
                .done(function (keyBackup) {
                    var syncObj = {
                        backup: keyBackup.data
                    };
                    resolve(syncObj);
                })
                .fail (function (e) {
                    switch (e.responseText.trim()) {
                    case 'No data':
                        require (['io.ox/core/notifications'], function (notify) {
                            notify.yell('error', gt('No backup data available'));
                        });
                        break;
                    }
                    console.log(e);
                    reject(new Error(e.responseText));
                });
            });
        }
    };

    //define default implementation as last object
    ext.point('oxguard/mailvelope/sync').extend(_.extend({
        index: 'last'
    }, syncHandlerObj));

    function addHandler (keyring) {
        var obj = ext.point('oxguard/mailvelope/sync').list()[0],
            def = $.Deferred();

        keyring.addSyncHandler(obj)
        .then(function () {
            def.resolve(keyring);
        }, function fail(error) {
            console.log('keyring.addSyncHandler error', error);
            def.reject(error);
        });
        return def;
    }

    return {
        addHandler: addHandler
    };
});
