define('mailvelope/settings/pane', [
    'io.ox/core/extensions',
    'mailvelope/main',
    'io.ox/core/api/account',
    'oxguard/util',
    'gettext!oxguard',
    'settings!oxguard',
    'less!pgp_mail/style'
], function (ext, api, accountAPI, util, gt, settings) {
    'use strict';

    function drawMailvelopeSettings (location) {
        location.removeClass('scrollable-pane').parent('.settings-detail-pane.scrollable').removeClass('scrollable').addClass('non-scrollable');
        location.append(
                $('<div>').addClass('mailvelope-settings-pane abs')
        );
        $.when(
            api.loaded,
            api.getKeyring(),
            accountAPI.getPrimaryAddress(),
            accountAPI.getDefaultDisplayName()
        ).then(function (mailvelope, keyring, mail, name) {
            var opt = {};
            if (mail && mail[1]) opt.email = mail[1];
            if (name) opt.fullName = name;
            mailvelope.createSettingsContainer('.mailvelope-settings-pane', keyring, opt);
        });
    }

    function doBackup () {
        $('.mailvelopeDiv').empty();
        return $.when(require(['mailvelope/sync/syncobject']), api.getKeyring()).then(function (syncobject, keyring) {
            syncobject.addHandler(keyring);
            var options = {
                initialSetup: true
            };
            $('.mailvelopeDiv').slideDown();
            var def = $.Deferred();
            keyring.createKeyBackupContainer ('.mailvelopeDiv', options)
            .then(function (popup) {
                return popup.isReady();
            }).then(function () {
                //remember, we did a backup
                settings.set('mailvelope/hasBackup', true).save();

                $('.mailvelopeDiv').empty().slideUp();
                return def.resolve();
            }, def.reject);

            return def;
        });
    }

    function doRecover () {
        $('.mailvelopeDiv').empty();
        require(['mailvelope/sync/syncobject'], function (syncobject) {
            api.getKeyring().then(function (keyring) {
                syncobject.addHandler(keyring);
                var options = {
                    restorePassword: true
                };
                $('.mailvelopeDiv').slideDown();
                keyring.restoreBackupContainer ('.mailvelopeDiv', options)
                .then(function (popup) {
                    popup.isReady()
                    .then(function () {
                        $('.mailvelopeDiv').empty().slideUp();
                    });
                });
            });
        });
    }

    function doUpload() {
        $.when(accountAPI.getPrimaryAddress())
        .then(function (mail) {
            var email;
            if (mail && mail[1]) email = mail[1];
            require(['mailvelope/sync/uploader', 'io.ox/core/notifications'], function (uploader, notify) {
                uploader.uploadPublic(email)
                .done (function () {
                    notify.yell('success', gt('OK'));
                })
                .fail (function (e) {
                    notify.yell('error', gt('Error') + ' ' + e);
                });

            });
        });
    }

    function section (title) {
        return $('<div class="oxguard_settings"/>')
            .append($('<legend class="sectiontitle">').text(title), '<br>');
    }

    function backup () {
        return [
            $('<p>').append(
                gt('Backup your Mailvelope private keys to the server.  The keys will be encrypted requiring a security code for restore'),
                '<br>',
                $('<button type="button" class="btn btn-primary">')
                    .text(gt('Backup'))
                    .click(doBackup)
            )
        ];
    }

    function restore () {
        return [
            $('<p>').append(
                gt('Discard previously saved private keys.'),
                '<br>',
                $('<button type="button" class="btn btn-default">')
                    .text(gt('Discard backup'))
                    .click(function () {
                        settings.set('mailvelope/hasBackup', false).save();
                    })
            ),
            $('<p>').append(
                gt('Restore previously saved private keys.'),
                '<br>',
                $('<button type="button" class="btn btn-primary">')
                    .text(gt('Restore'))
                    .click(doRecover)
            )
        ];
    }

    function uploadOption () {
        return [
            $('<p>').append(
                //#. %s - the product name
                gt('Upload your Mailvelope public keys to the %s server so that other people can send you encrypted emails.', window.oxguarddata.productName),
                '<br>',
                $('<button type="button" class="btn btn-primary">')
                    .text(gt('Upload Public Key'))
                    .click(doUpload)
            )
        ];
    }

    function drawAdvancedSettings (node) {
        node.append(addAdvancedSettings());
    }

    function addAdvancedSettings () {
        var hasBackup = settings.get('mailvelope/hasBackup', false);
        return $('<div>').css('max-width', '800px').append(
            $('<h1>').append($('<span>').text(gt('Mailvelope'))),
            $('<div class="mailvelopeDiv">'),
            section(gt('Backup and Recovery')).addClass('backup restore').append(
                hasBackup ? restore() : backup()
            ),
            section(gt('Upload Public Key')).append(uploadOption())
        );
    }

    settings.on('change:mailvelope/hasBackup', function (ev, hasBackup) {
        $('.oxguard_settings.backup.restore:visible').replaceWith(
            section(gt('Backup and Recovery')).addClass('backup restore').append(
                hasBackup ? restore() : backup()
            )
        );
    });

    ext.point('mailvelope/settings/detail').extend({
        index: 203,
        id: 'mailvelope_advanced',
        draw: function () {
            var node = this;
            util.hasSetupDone()
            .done(function () {
                node.append(addAdvancedSettings());
            })
            .fail(function () {
                ox.launch('io.ox/settings/main', { id: 'oxguard' }).done(function () {
                    this.setSettingsPane({ id: 'oxguard' });
                });
            });

        },
        save: _.noop
    });

    return {
        drawMailvelopeSettings: drawMailvelopeSettings,
        drawAdvancedSettings: drawAdvancedSettings,
        doUpload: doUpload,
        doBackup: doBackup
    };
});
