/**
 *
 */

package com.openexchange.obs.api;

import static com.openexchange.obs.api.Architecture.i586;
import static com.openexchange.obs.api.Architecture.x86_64;
import static java.util.Arrays.sort;
import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertEquals;
import java.util.Collection;
import org.junit.Test;

/**
 * @author marcus
 *
 */
public class ArchitectureTest {

    /**
     * Test method for {@link com.openexchange.obs.api.Architecture#parseArchitecture(java.lang.String)}.
     * @throws BuildServiceException
     */
    @SuppressWarnings("static-method")
    @Test
    public final void testParseArchitecture() throws BuildServiceException {
        {
            Architecture toTest = Architecture.parse("i586");
            assertEquals(i586, toTest);
            toTest = Architecture.parse("x86_64");
            assertEquals(x86_64, toTest);
        }
        {
            Collection<Architecture> tmp = Architecture.parseArchitecture("i586,x86_64");
            Architecture[] toTest = tmp.toArray(new Architecture[tmp.size()]);
            sort(toTest);
            assertArrayEquals(new Architecture[] { i586, x86_64 }, toTest);
        }
    }
}
