/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.interceptor;

import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.guard.api.GuardApis;
import com.openexchange.guard.internal.AbstractGuardAccess;
import com.openexchange.guard.internal.GuardApiImpl;
import com.openexchange.server.ServiceLookup;
import com.openexchange.user.UserServiceInterceptor;

/**
 * {@link GuardUserServiceInterceptor}
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public class GuardUserServiceInterceptor extends AbstractGuardAccess implements UserServiceInterceptor {

    private final ServiceLookup services;

    /**
     * Initializes a new {@link GuardUserServiceInterceptor}.
     */
    public GuardUserServiceInterceptor(final ServiceLookup services) {
        super();
        this.services = services;
    }

    @Override
    public int getRanking() {
        return 0;
    }

    @Override
    public void beforeCreate(final Context context, final User user, final Contact contactData) throws OXException {
        // Nothing
    }

    @Override
    public void afterCreate(final Context context, final User user, final Contact contactData) {
        // Nothing
    }

    @Override
    public void beforeUpdate(final Context context, final User user, final Contact contactData, final Map<String, Object> properties) throws OXException {
        // Nothing
    }

    @Override
    public void afterUpdate(final Context context, final User user, final Contact contactData, final Map<String, Object> properties) throws OXException {
        // nothing
    }

    @Override
    public void beforeDelete(final Context context, final User user, final Contact contactData) throws OXException {
        try {
            GuardApiImpl guardApi = getGuardApi(GUARDADMIN_ENDPOINT);
            if (null == guardApi) {
                // Guard end point not available
                return;
            }
            guardApi.doCallPut(GuardApis.mapFor("action", "user_delete"), new JSONObject(4).put("context_id", context.getContextId()).put("user_id", user.getId()), Void.class);
        } catch (Exception e) {
            Logger logger = org.slf4j.LoggerFactory.getLogger(GuardUserServiceInterceptor.class);
            logger.error("Failed to delete user {} in context {} at guard end point.", user.getId(), context.getContextId(), e);
        }
    }

    @Override
    public void afterDelete(final Context context, final User user, final Contact contactData) throws OXException {
        // Nothing
    }

}
