//
//package com.openexchange.guard.file.storage;
//
//import java.io.IOException;
//import java.io.InputStream;
//import com.openexchange.exception.OXException;
//import com.openexchange.file.storage.Document;
//import com.openexchange.file.storage.File;
//import com.openexchange.file.storage.composition.AbstractDelegatingIDBasedFileAccess;
//import com.openexchange.file.storage.composition.IDBasedFileAccess;
//import com.openexchange.guard.api.GuardApi;
//import com.openexchange.guard.file.storage.exceptions.GuardFileStorageExceptionCodes;
//import com.openexchange.guard.internal.authentication.AuthenticationToken;
//import com.openexchange.guard.internal.authentication.AuthenticationTokenHandler;
//import com.openexchange.mail.mime.MimeType2ExtMap;
//import com.openexchange.session.Session;
//
///**
// * {@link GuardAwareIDBasedFileAccess}
// *
// * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
// * @since v7.8.2
// */
//public class GuardAwareIDBasedFileAccess extends AbstractDelegatingIDBasedFileAccess {
//
//    private final Session session;
//    private final EncryptedFileRecognizer guardFileRecognizer;
//    private final GuardApi guardApi;
//
//    private class GuardDocument extends Document {
//
//        private final InputStream guardInputStream;
//
//        /**
//         * Initializes a new {@link GuardDocument}.
//         * 
//         * @param guardInputStream
//         * @throws OXException
//         */
//        public GuardDocument(Document document) throws OXException {
//            super(document);
//            //We do not know the size of the decrypted file yet
//            setSize(-1);
//            //Removing the PGP extension at the end of the name
//            setName(getName().replaceFirst("(?i)\\.pgp$", ""));
//            //Guessing the content type of the decrypted file
//            setMimeType(MimeType2ExtMap.getContentType(getName()));
//            //Updateing file meta data as well
//            setFile(updateFileMetaData(getFile()));
//            AuthenticationToken authenticationToken = new AuthenticationTokenHandler().requireForSession(session);
//            this.guardInputStream = new GuardDecryptedInputStream(guardApi, authenticationToken, document.getData());
//        }
//        
//        /*
//         * (non-Javadoc)
//         * 
//         * @see com.openexchange.file.storage.Document#getData()
//         */
//        @Override
//        public InputStream getData() throws OXException {
//            return guardInputStream;
//        }
//    }
//
//    /**
//     * Initializes a new {@link GuardAwareIDBasedFileAccess}.
//     * 
//     * @param guardApi The guard api endpoint to use
//     * @param serviceLookup ServiceLookup
//     * @param guardApi The api object for accessing guard
//     * @oaran GuardFileRecognizer strategy to decide which files should be treated as encrypted guard files
//     * @param fileAccess The {@link IDBasedFileAccess} to delegate to
//     * @param Session The session
//     */
//    public GuardAwareIDBasedFileAccess(GuardApi guardApi, EncryptedFileRecognizer guardFileRecognizer, IDBasedFileAccess fileAccess, Session session) {
//        super(fileAccess);
//        this.guardApi = guardApi;
//        this.guardFileRecognizer = guardFileRecognizer;
//        this.session = session;
//    }
//
//    /**
//     * Checks if the document is an encrypted documents
//     * 
//     * @param document The document to check
//     * @return True, if the document is encrypted, false otherwise
//     */
//    private boolean isEncryptedGuardFile(Document document) {
//        return guardFileRecognizer.isEncrypted(document);
//    }
//
//    /**
//     * Decrypts the given document
//     * 
//     * @param document The document to decrypt
//     * @return The decrypted document if the document is encrypted or the original document if the document is not encrypted
//     * @throws OXException
//     */
//    private Document createDecryptedDocument(Document document) throws OXException {
//        if (isEncryptedGuardFile(document)) {
//            return new GuardDocument(document);
//        }
//        return document;
//    }
//    
//    
//    /**
//     * Internal method to update/set Guard related meta data.
//     * @param fileMetadata The meta data to update
//     * @return The meta data
//     */
//    private File updateFileMetaData(File fileMetadata) {
//        //We do not know the size of the decrypted file yet
//        fileMetadata.setFileSize(-1);
//        fileMetadata.setFileMD5Sum("");
//        //Removing the PGP extension at the end of the name
//        fileMetadata.setFileName(fileMetadata.getFileName().replaceFirst("(?i)\\.pgp$", ""));
//        //Guessing the content type of the decrypted file
//        fileMetadata.setFileMIMEType(MimeType2ExtMap.getContentType(fileMetadata.getFileName()));
//        return fileMetadata;
//    }
//
//    @Override
//    public InputStream getDocument(String id, String version) throws OXException {
//        return createDecryptedDocument(fileAccess.getDocumentAndMetadata(id, version)).getData();
//    }
//
//    @Override
//    public InputStream getDocument(String id, String version, long offset, long length) throws OXException {
//        Document document = fileAccess.getDocumentAndMetadata(id, version);
//        if (isEncryptedGuardFile(document)) {
//            try {
//                //we cannot support random file access so we provide a PartialInputStream which allows to skip
//                return new PartialInputStream(createDecryptedDocument(document).getData(), offset, length);
//            } catch (IOException e) {
//                throw GuardFileStorageExceptionCodes.IO_ERROR.create(e, e.getMessage());
//            }
//        }
//        return fileAccess.getDocument(id, version, offset, length);
//    }
//
//    @Override
//    public Document getDocumentAndMetadata(String id, String version) throws OXException {
//        return createDecryptedDocument(fileAccess.getDocumentAndMetadata(id, version));
//    }
//
//    @Override
//    public Document getDocumentAndMetadata(String id, String version, String clientEtag) throws OXException {
//        return createDecryptedDocument(fileAccess.getDocumentAndMetadata(id, version, clientEtag));
//    }
//
//    @Override
//    public InputStream optThumbnailStream(String id, String version) throws OXException {
//        /* Thumbnails are not supported for encrypted files */
//        return null;
//    };
//}
