package com.openexchange.guard.bruteForceDetection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.exception.OXException;
import com.openexchange.guard.osgi.Services;

/**
 * Class to return current brute force detection service
 * @author <a href="mailto:greg.hill@open-xchange.com">Greg Hill</a>
 *
 */
public class GuardBruteForceDetection {

    private static Logger LOG = LoggerFactory.getLogger(GuardBruteForceDetection.class);

    public static GuardBruteForceDetectionService getBruteForceDetectionService () {
        if (Services.getServiceLookup().getService(GuardBruteForceDetectionService.class) != null)
            try {
                return Services.getService(GuardBruteForceDetectionService.class);
            } catch (OXException e) {
                LOG.error("Problem getting BruteForceDetection Service");
            }
        return new GuardBruteForceDetectionServiceDefaultImpl();
    }
}
