/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016-2020 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.servlets.drive;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.openexchange.guard.servlets.AbstractGuardServlet;
import com.openexchange.guard.servlets.GuardServletAction;
import com.openexchange.guard.servlets.authentication.OXGuardSessionAuthenticationHandler;
import com.openexchange.guard.servlets.drive.upload.DriveUploadServlet;

/**
 * Servlet for handling OX Guard requests related to the drive module
 *
 * @see {@link DriveUploadServlet} for uploading files to drive
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.0
 */
public class DriveServlet extends AbstractGuardServlet {

    private static final long serialVersionUID = 4203739054745114921L;

    // GET actions
    private static final String DRIVE_GET_FILE_ACTION = "get";
    private static final String DRIVE_GET_FILE_REMOVE_ENCRYPTION_ACTION = "remove";

    // POST actions
    private static final String DRIVE_POST_ENCRYPT_FILE_ACTION = "encrypt";


    private final HashMap<String, GuardServletAction> servletGetActions;
    private final HashMap<String, GuardServletAction> servletDeleteActions;
    private final HashMap<String, GuardServletAction> servletPutActions;
    private final HashMap<String, GuardServletAction> servletPostActions;

    public DriveServlet() {

        //Authentication handler which checks for a valid OX UI session
        OXGuardSessionAuthenticationHandler uiSessionAuthentication = new OXGuardSessionAuthenticationHandler();

        //GET Actions
        servletGetActions = new HashMap<String, GuardServletAction>();
        servletGetActions.put(DRIVE_GET_FILE_ACTION, new DriveGetFileAction().setAuthenticationHandler(uiSessionAuthentication));
        servletGetActions.put(DRIVE_GET_FILE_REMOVE_ENCRYPTION_ACTION, new DriveRemoveEncryptionAction().setAuthenticationHandler(uiSessionAuthentication));

        //DELETE Actions
        servletDeleteActions = new HashMap<String, GuardServletAction>();

        //PUT Actions
        servletPutActions = new HashMap<String, GuardServletAction>();

        //POST Actions
        servletPostActions = new HashMap<String, GuardServletAction>();
        servletPostActions.put(DRIVE_POST_ENCRYPT_FILE_ACTION, new DriveEncryptFileAction().setAuthenticationHandler(uiSessionAuthentication));
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        doAction(request, response, servletGetActions);
    }

    @Override
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) {
        doAction(request, response, servletDeleteActions);
    }

    @Override
    protected void doPut(HttpServletRequest request, HttpServletResponse response) {
        doAction(request, response, servletPutActions);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        doAction(request, response, servletPostActions);
    }
}
