package com.openexchange.guard.keys;

import java.util.Collection;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import com.openexchange.exception.OXException;


/**
 * {@link HKPClientService}
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v2.4.0
 */
public interface HKPClientService {

    /**
     * Tries to find all public PGP keys for the given email
     * @param clientToken an identification token put into the X-UI-INTERNAL-ACCOUNT-ID header, or null not not set the header
     * @param email The email to get the public keys for
     * @return A list of public keys found for the given email
     * @throws OXException
     */
    public Collection<PGPPublicKeyRing> find(String clientToken, String email) throws OXException;

    /**
     * Tries to find a public PGP keys for the given email
     * @param clientToken an identification token put into the X-UI-INTERNAL-ACCOUNT-ID header, or null not not set the header
     * @param email The email to get the public keys for
     * @return The first found public key ring for the given email
     * @throws OXException
     */
    public PGPPublicKeyRing findFirst(String clientToken, String email) throws OXException;
}
