Name:          open-xchange-guard-file-storage
BuildArch:     noarch
#!BuildIgnore: post-build-checks
%if 0%{?rhel_version} && 0%{?rhel_version} >= 700
BuildRequires: ant
%else
BuildRequires: ant-nodeps
%endif
%if 0%{?rhel_version} && 0%{?rhel_version} == 600
BuildRequires: java7-devel
%else
BuildRequires: java-devel >= 1.7.0
%endif
BuildRequires: open-xchange-guard
Version:       2.4.0
%define        ox_release 8
Release:       %{ox_release}_<CI_CNT>.<B_CNT>
Group:         Applications/Productivity
License:       GPL-2.0
BuildRoot:     %{_tmppath}/%{name}-%{version}-build
URL:           http://www.open-xchange.com/
Source:        %{name}_%{version}.orig.tar.bz2
Summary:       OX Guard File Storage
Autoreqprov:   no
Requires:      open-xchange-guard >= 2.4.0-0
Provides:      open-xchange-guard-file-storage = 2.4.0-0
Conflicts:     open-xchange-guard-s3-storage

%description
This package adds the bundles for file storage support to the OX Guard product.

Authors:
--------
    Open-Xchange

%prep

%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -lib build/lib -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build

%post
. /opt/open-xchange/lib/oxfunctions.sh

# prevent bash from expanding, see bug 13316
GLOBIGNORE='*'

if [ ${1:-0} -eq 1 ]; then # only during first install

    # SoftwareChange_Request 3105
    # Installing open-xchange-guard created a backup so we are able to take
    # over the previous config params to the new location.
    old_core_file_back=/opt/open-xchange/etc/guard.properties.move
    file_properties=/opt/open-xchange/etc/guard-file.properties
    key="com.openexchange.guard.storage.file.uploadDirectory" 

    if [ -e $old_core_file_back ] && [ -e $file_properties ]; then
        #if property is uncommented
        if $(ox_exists_property ${key} ${old_core_file_back}); then
            value=$(ox_read_property ${key} ${old_core_file_back})
            #and property has a value
            if [ -n "${value}" ]; then
                ox_comment ${key} remove ${file_properties}
                ox_set_property ${key} "${value}" ${file_properties}
            fi
        fi
        # after open-xchange-guard and open-xchange-storage-* are installed we
        # can clean up as properties have been moved
        rm ${old_core_file_back}
    fi

elif [ ${1:-0} -eq 2 ]; then # only when updating
    : #remove noop when adding SCRs for updates
fi

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/bundles/
/opt/open-xchange/bundles/*
%dir /opt/open-xchange/osgi/bundle.d/
/opt/open-xchange/osgi/bundle.d/*
%config(noreplace) /opt/open-xchange/etc/guard-file.properties

%changelog
* Wed Apr 20 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Build for patch 2016-04-22 (3245)
* Wed Mar 30 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second candidate for 2.4.0 release
* Thu Mar 24 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First candidate for 2.4.0 release
* Wed Mar 16 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Fifth preview of 2.4.0 release
* Fri Mar 04 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Fourth preview of 2.4.0 release
* Sat Feb 20 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Third candidate for 2.4.0 release
* Fri Feb 05 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Second candidate for 2.4.0 release
* Fri Feb 05 2016 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
First candidate for 2.4.0 release
* Mon Nov 16 2015 Ioannis Chouklis <ioannis.chouklis@open-xchange.com>
Initial release
