/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.storage.s3;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.model.Region;
import com.openexchange.guard.config.Config;


/**
 * Storage implementation for S3 type object stores.
 * 
 * @author benjamin.otterbach@open-xchange.com
 */
public class S3ClientFactory {

	public static AmazonS3Client s3Client;
	private static Logger logger = LoggerFactory.getLogger(S3ClientFactory.class);
	
	public static void init() throws AmazonServiceException, AmazonClientException {
        BasicAWSCredentials credentials = new BasicAWSCredentials(Config.getS3AccessKey(), Config.getS3SecretKey());
        
        /*
         * Instantiate client
         */
        s3Client = new AmazonS3Client(credentials);
        s3Client.setS3ClientOptions(new S3ClientOptions().withPathStyleAccess(true));

        /*
         * Configure client
         */
        if (Config.getS3Endpoint().length() > 0) {
        	s3Client.setEndpoint(Config.getS3Endpoint());
        } else {
        	try {
        		s3Client.setRegion(com.amazonaws.regions.Region.getRegion(Regions.fromName(Config.getS3Region())));
	        } catch (IllegalArgumentException e) {
	        	logger.error("Error at s3Client setRegion", e);
	        }
        }
        
        /*
         * Check if configured S3 bucket exists, otherwise create.
         */
        if (!s3Client.doesBucketExist(Config.getS3BucketName())) {
        	s3Client.createBucket(Config.getS3BucketName(), Region.fromValue(Config.getS3Region()));
        }
	}
	
}
