/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.setup;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.DbStrings;
import com.openexchange.guard.database.Keymanager;
import com.openexchange.guard.database.OGInit;
import com.openexchange.guard.encr.EncrLib;
import com.openexchange.guard.encr.GuardKeys;
import com.openexchange.guard.util.CheckOx;

/**
 * First time setup of OxGuard database and the tables within Will create one encrypted item in keytable for master
 *
 * @author greg
 */
public class OxDatabaseCreateor {

	private static Logger logger = LoggerFactory.getLogger(OxDatabaseCreateor.class);

    private final String mysqlIP = com.openexchange.guard.config.Config.getMysqlIP();// IP address of configdb

    private final String mysqlUsername = com.openexchange.guard.config.Config.getMysqlUsername();

    private final String mysqlPassword = com.openexchange.guard.config.Config.getMysqlPassword();

    private final String OGmysqlIP = com.openexchange.guard.config.Config.getMysqlIPOxGuard();

    public boolean create(int version) {

        try {
        	// Verify REST API is working
        	if (!CheckOx.oxAlive()) {
        		logger.error("Unable to establish REST API.  Please check settings and make sure the OX backend has open-xchange-rest installed");
        		return (false);
        	}

            Class.forName("com.mysql.jdbc.Driver").newInstance();

            String OGmysqlConnectionString = "jdbc:mysql://" + OGmysqlIP + "/?user=" + mysqlUsername + "&password=" + mysqlPassword;
            String OGRead = Config.ogMySqlReadIP == null ? null : ("jdbc:mysql://" + Config.ogMySqlReadIP + "/");
            String OgWrite = "jdbc:mysql://" + OGmysqlIP + "/";
            if (Config.ogShardIP == null) {
                Config.ogShardIP = OGmysqlIP;
            }
            String OgShardWrite = "jdbc:mysql://" + Config.ogShardIP + "/";
            String OgShardRead = Config.ogShardReadIP == null ? null : ("jdbc:mysql://" + Config.ogShardReadIP + "/");
            String OGShardmysqlConnectionString = "jdbc:mysql://" + Config.ogShardIP + "/?user=" + mysqlUsername + "&password=" + mysqlPassword;
            Connection intconn = DriverManager.getConnection(OGmysqlConnectionString);
            Connection configdb = DriverManager.getConnection(Config.getConfigDbConnectionString());
            Connection shardconn = DriverManager.getConnection(OGShardmysqlConnectionString);

            String createDatabase = "CREATE DATABASE " + Config.dbSchemaBaseName + " DEFAULT CHARACTER SET utf8 DEFAULT COLLATE utf8_general_ci";

            try {
                mysqlExecute(createDatabase, intconn);
            } catch (Exception ex) {
            	if (ex.getMessage().contains("database exists")) {
            		logger.info("oxguard database exists, using");
            	} else {
	                logger.error("Unable to create " + Config.dbSchemaBaseName + " database", ex);
	                return (false);
            	}
            }

            // Register database
            RegisterDb.register(configdb, OgWrite, OGRead, "com.mysql.jdbc.Driver", mysqlUsername, mysqlPassword, Config.dbSchemaBaseName);

            createDatabase = "CREATE DATABASE " + Config.getShardBaseName() + "1";

            try {
                mysqlExecute(createDatabase, shardconn);
            } catch (Exception ex) {
            	if (ex.getMessage().contains("database exists")) {
            		logger.info("oxguard database exists, using");
            	} else {
	                logger.error("Unable to create " + Config.getShardBaseName() + "1 database", ex);
	                return (false);
            	}
            }
            RegisterDb.register(configdb, OgShardWrite, OgShardRead, "com.mysql.jdbc.Driver", mysqlUsername, mysqlPassword, Config.getShardBaseName() + "1");

            intconn.close();
            OGInit.initGuardDatabase();
            OGmysqlConnectionString = "jdbc:mysql://" + OGmysqlIP + "/" + Config.dbSchemaBaseName + "?user=" + mysqlUsername + "&password=" + mysqlPassword;

            Connection conn = DriverManager.getConnection(OGmysqlConnectionString);

            // Master KeyTable
            String createKeyTable = DbStrings.createGlobalKeyTable;

            try {
                mysqlExecute(createKeyTable, conn);
            } catch (Exception e) {
            	if (e.getMessage().contains("already exists")) {
            		logger.info("master keytable exists, using");
            	} else {
            		logger.error("Unable to create master keytable", e);
                    return (false);
            	}
            }
            try {
                Keymanager keyman = new Keymanager();
                GuardKeys keys = keyman.createMasterKeysNC(-1, 0, "dont@remove.com", "master", Config.mpass, "", false,true);// Create master key for password recovery
                if (keys == null) {
                	logger.error("Unable to create master keys");
                    return (false);
                }
                GuardKeys keys2 = keyman.createMasterKeysNC(-2, 0, "dont@remove.com", "master", Config.rpass, "", false,true);// Create master key for client encryption
                if (keys2 == null) {
                	logger.error("Unable to create master keys for client encryption");
                    return (false);
                }
            } catch (Exception ex) {
            		logger.error("Unable to create master keys", ex);
            		return (false);

            }

            String createOgEmail = DbStrings.createOGEmail;
            try {
                mysqlExecute(createOgEmail, conn);
            } catch (Exception ex) {
            	if (ex.getMessage().contains("already exists")) {
            		logger.info("ogEmail exists, using");
            	} else {
            		logger.error("Unable to create ogEmail table", ex);
                    return (false);
            	}
            }

            String sharding = DbStrings.createShardingTable;
            try {
                mysqlExecute(sharding, conn);
                sharding = "INSERT INTO sharding VALUES (1, 0)";
                mysqlExecute(sharding, conn);
            } catch (Exception ex) {
            	if (ex.getMessage().contains("already exists")) {
            		logger.info("sharding exists, using");
            	} else {
            		logger.error("Unable to create sharding table", ex);
                    return (false);
            	}

            }

            String createSession = DbStrings.createSessions;

            try {
                mysqlExecute(createSession, conn);

            } catch (Exception ex) {
            	if (ex.getMessage().contains("already exists")) {
            		logger.info("oxguard_session exists, using");
            	} else {
            		logger.error("Unable to create oxguard_session table", ex);
                    return (false);
            	}
            }

            String cacheTable = DbStrings.createRSACache;

            try {
                mysqlExecute(cacheTable, conn);

            } catch (Exception ex) {
            	if (ex.getMessage().contains("already exists")) {
            		logger.info("cache exists, using");
            	} else {
            		logger.error("Unable to create cache table", ex);
                    return (false);
            	}

            }

            String fileCacheTable = DbStrings.createFileCacheTable;
            try {
                mysqlExecute(fileCacheTable, conn);

            } catch (Exception ex) {
            	if (ex.getMessage().contains("already exists")) {
            		logger.info("FileCache exists, using");
            	} else {
            		logger.error("Unable to create FileCache table", ex);
                    return (false);
            	}

            }

            String publicPGPTable = DbStrings.createPGPPublic;
            try {
                mysqlExecute(publicPGPTable, conn);
            } catch (Exception ex) {
            	if (ex.getMessage().contains("already exists")) {
            		logger.info("PublicPGP exists, using");
            	} else {
            		logger.error("Unable to create PublicPGP table", ex);
                    return (false);
            	}

            }
            String badTable = DbStrings.createBadTable;
            try {
                mysqlExecute(badTable, conn);
            } catch (Exception ex) {
            	if (ex.getMessage().contains("already exists")) {
            		logger.info("Bad tables exists, using");
            	} else {
            		logger.error("Unable to create Bad table", ex);
                    return (false);
            	}

            }

            String createIOX = DbStrings.createIOXTable;
            try {
                mysqlExecute(createIOX, conn);
            } catch (Exception ex) {
            	if (ex.getMessage().contains("already exists")) {
            		logger.info("iox exists, using");
            	} else {
            		logger.error("Unable to create iox table", ex);
                    return (false);
            	}


            }
            String rsacache = DbStrings.createKeyCache;
            try {
                mysqlExecute(rsacache, conn);
            } catch (Exception ex) {
            	if (ex.getMessage().contains("already exists")) {
            		logger.info("key_cache exists, using");
            	} else {
            		logger.error("Unable to create key_cache keytable", ex);
                    return (false);
            	}
            }

            String remoteKeys = DbStrings.createRemoteKeys;
            try {
                mysqlExecute(remoteKeys, conn);
            } catch (Exception ex) {
                if (ex.getMessage().contains("already exists")) {
                    logger.info("remote_keys exists, using");
                } else {
                    logger.error("Unable to create remote_keys keytable", ex);
                    return (false);
                }
            }

            String remoteKeysCache = DbStrings.createRemoteKeyCache;
            try {
                mysqlExecute(remoteKeysCache, conn);
            } catch (Exception ex) {
                if (ex.getMessage().contains("already exists")) {
                    logger.info("remote_key_cache exists, using");
                } else {
                    logger.error("Unable to create remote_key_cache keytable", ex);
                    return (false);
                }
            }

            String deletedKeys = DbStrings.createDeletedKeys;
            try {
                mysqlExecute(deletedKeys, conn);
            } catch (Exception ex) {
                if (ex.getMessage().contains("already exists")) {
                    logger.info("deletedkeys table exists, using");
                } else {
                    logger.error("Unable to create deletedkeys table", ex);
                    return (false);
                }
            }

            String settingsTable = DbStrings.createGlobalSettings;
            try {
                mysqlExecute(settingsTable, conn);
                String setVersion = "INSERT INTO global_settings VALUES ('version','" + version + "');";
                mysqlExecute(setVersion, conn);
                String setToken = "INSERT INTO global_settings VALUES ('token', '" + EncrLib.getsalt() + "');";
                mysqlExecute(setToken, conn);
            } catch (Exception ex) {
            	if (ex.getMessage().contains("already exists")) {
            		logger.info("global_settings exists, using");
            	} else {
            		logger.error("Unable to create global_settings table or problems updating", ex);
                    return (false);
            	}

            }

            String PGPLookup = DbStrings.createPGPKeysLookupTable;
            try {
                mysqlExecute(PGPLookup, conn);
            } catch (Exception ex) {
            	if (ex.getMessage().contains("already exists")) {
            		logger.info("PGPKey Table exists, using");
            	} else {
            		logger.error("Unable to create PGPKeyTable keytable", ex);
                    return (false);
            	}
            }


   //         try {
   //             Manager.createTables(conn);
   //         } catch (Exception ex) {
    //            logger.error("Unable to create guest tables");
    //            logger.error(ex);
    //        }

            conn.close();

        } catch (Exception e) {
        	logger.error("Error creating the database", e);
            return (false);
        }

        return (true);
    }

    private void mysqlExecute(String command, Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute(command);
        stmt.close();
    }
}
