package com.openexchange.guard.server.connectionPooling;

import org.apache.http.impl.client.CloseableHttpClient;


/**
 * Service providing access to a set of connection pools
 */
public class HttpConnectionPoolService {

    private static ConnectionPool cookielessPool;
    private static ConnectionPool cookiePool;
    private static HttpPoolingStats stats;


    /**
     * Initializes all connection pools
     */
    public static void initialize() {
        cookielessPool = new ConnectionPool("User Auth", ConnectionPool.CookieHandlingMode.CookieHandligDissabled);
        cookiePool = new ConnectionPool("API", ConnectionPool.CookieHandlingMode.CookieHandlingEnabled);
        stats = new SummarizedHttpPoolingStats(cookielessPool.getConncetionManager().getTotalStats(),
                                               cookiePool.getConncetionManager().getTotalStats());
    }

    /**
     * Closes all connection pools
     */
    public static void closeAll() {
        cookielessPool.close();
        cookiePool.close();
    }

    /**
     * Gets a connection from the cookieless connection pool
     * @return HttClient connection with disabled cookie handling
     */
    public static CloseableHttpClient getCookielessClient() {
        return cookielessPool.getHttpClient();
    }

    /**
     * Gets a connection from the default connection pool
     * @return HttClient connection with default cookie handling applied
     */
    public static CloseableHttpClient getClient() {
        return cookiePool.getHttpClient();
    }

    /**
     * @return A statistic object for the connection pool service
     */
    public static HttpPoolingStats getStats() {
        return stats;
    }

    /**
     * Resets known connection pools
     */
    public static void reset() {
        cookielessPool.reset();
        cookiePool.reset();
    }
}
