
package com.openexchange.guard.server;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.exceptions.GuardMissingParameter;
import com.openexchange.guard.logging.LogAction;
import com.openexchange.guard.server.authentication.GuardAuthRole;
import com.openexchange.guard.server.authentication.GuardAuthRoles;
import com.openexchange.guard.util.Core;

public class SupportServlet extends HttpServlet {

    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(SupportServlet.class);

    @Override
    protected void doPost(HttpServletRequest request,
        HttpServletResponse response) throws ServletException, IOException {

        String action;
        try {
            action = Core.getStringParameter(request, "action", true);
        } catch (GuardMissingParameter e1) {
            Core.sendFail(response, "Missing parameter action");
            return;
        }
        logger.info(String.format("Suport command sent \"%s\" from IP %s", action, Core.getIP(request)));

        //Executing this request is only allowed if the user is in the supportAPI role
        if (GuardAuthRoles.isUserInRole(request, GuardAuthRole.SupportAPI)) {
            try {
                if (action != null) {
                    switch (action) {
                        case "expose_key":
                            new SupportHandler().ExposeKey(request, response);
                            break;
                        case "reset_password":
                            new SupportHandler().ResetPassword(request, response);
                            break;
                        case "delete_user":
                            new SupportHandler().DeleteUser(request, response);
                            break;
                        default:
                            logger.info(String.format("Ignoring unknown support command \"%s\"", action));
                            Core.sendFail(response, "Unknown action");
                            break;
                    }
                }
                else {
                    Core.sendFail(response, "Missing parameter action");
                }
            } catch (Exception e) {
                logger.error(String.format("Error processing support command \"%s\": %s",
                    action,
                    e.getMessage()));
                LogAction.setFail();
                Core.sendFail(response, e.getMessage());
            }
        }
        else {
            //User is not allowed to call the support API
            String errorMessage =
                String.format("User is not allowed to execute command %s",
                    action);
            logger.info(errorMessage);
            Core.sendAnswer(response, HttpServletResponse.SC_FORBIDDEN, errorMessage);
        }
    }
}
