package com.openexchange.guard.server;

import java.lang.management.ManagementFactory;
import java.text.NumberFormat;
import com.openexchange.guard.server.connectionPooling.HttpPoolingStats;

public class GuardServerStats implements GuardServerStatsMBean {

        private final HttpPoolingStats stats;

        GuardServerStats(HttpPoolingStats httpPoolingStats){
            this.stats = httpPoolingStats;
        }


		private final long mb = 1048576;
		@Override
        public synchronized String getPoolInfo() {
			return ("HTTP pool connections- In Pool : " + stats.getAvailable() + " Active: " + stats.getLeased() + " Hold: " + stats.getPending());
		}

		@Override
        public synchronized String getMemoryInfo() {
			return ("Total: " + NumberFormat.getIntegerInstance().format(getTotalMemory()) + " Used: " + NumberFormat.getIntegerInstance().format(getUsedMemory()) + " Free: " + NumberFormat.getIntegerInstance().format(getFreeMemory()) + " Max: " + NumberFormat.getIntegerInstance().format(getMaxMemory()));
		}

		@Override
        public synchronized int getPoolCount() {
			return (stats.getAvailable());
		}

		@Override
        public synchronized int getPoolActive() {
			return (stats.getLeased());
		}

		@Override
        public synchronized int getPoolWaiting() {
			return (stats.getPending());
		}

		@Override
        public synchronized long getUsedMemory() {
			Runtime runtime = Runtime.getRuntime();
			return (runtime.totalMemory() - runtime.freeMemory());
		}

		@Override
        public synchronized long getFreeMemory() {
			return (Runtime.getRuntime().freeMemory());
		}

		@Override
        public synchronized long getMaxMemory() {
			return (Runtime.getRuntime().maxMemory());
		}

		@Override
        public synchronized long getTotalMemory() {
			return (Runtime.getRuntime().totalMemory());
		}

		@Override
        public int getThreadCount() {
			return(ManagementFactory.getThreadMXBean().getThreadCount());
		}
}
