package com.openexchange.guard.server;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.support.UserDeleter;


public class Admin {

    private static Logger logger = LoggerFactory.getLogger(AdminServlet.class);

    /**
     * Delete user from the Guard key tables and lookup.  Move keys to deletedKey table
     * @param id
     * @param cid
     * @return
     * @throws Exception
     */
    public boolean delete (int id, int cid) throws Exception {
        try {
            new UserDeleter().deleteWithBackup(id, cid);
            return true;
        }
        catch (Exception ex) {
            logger.error("Problem moving user keys to deleted ", ex);
            return false;
        }
    }

    /**
     * Delete context from the Guard key tables and lookup.  Move keys to deletedKey table
     * @param id
     * @param cid
     * @return
     * @throws Exception
     */
    public boolean deleteContext (int cid) throws Exception {
        if (cid < 0) {
            return false;
        }
        try {
            new UserDeleter().deleteWithBackup(cid);
            return true;
        } catch (Exception ex) {
            logger.error("Problem moving user keys to deleted ", ex);
            return (false);
        }
    }
}
