package com.openexchange.guard.pgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.database.Access;
import com.openexchange.guard.encr.GuardKeys;

public class pgptest {

	
	public static void testsign () throws Exception {
		Access acc = new Access();
		GuardKeys keys = acc.getKeys(3, 1);
		PGPSecretKey secretKey = keys.getPGPSecretKey();
        PGPPrivateKey privateKey = PgpKeys.decodePrivate(secretKey, "ghill1", keys.getSalt());
		PGPPublicKey pub = secretKey.getPublicKey();
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		String testdata = "This is a test";
		ByteArrayInputStream input = new ByteArrayInputStream(testdata.getBytes());
		signFile(input, out,secretKey, privateKey, pub);
		System.out.println(out.toString());
		InputStream in = new ByteArrayInputStream(out.toByteArray());
		decodeTest (in, privateKey, pub);
	//	verifyFile(in, keys.pubring);
		//testsign (privateKey, pub);
	}
	
	// Test signing to self.  Private and public are for the same keypair.
	private static void testsign (PGPPrivateKey privateKey, PGPPublicKey pub) throws Exception {
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		String testdata = "This is the test text";
		ByteArrayInputStream dataStream = new ByteArrayInputStream(testdata.getBytes());
        // Initialize encrypted data generator
        BcPGPDataEncryptorBuilder builder = new BcPGPDataEncryptorBuilder(PGPEncryptedData.AES_256);  
        builder.setSecureRandom(new SecureRandom());
        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator(builder); 
        	BcPublicKeyKeyEncryptionMethodGenerator encKeyGen = new BcPublicKeyKeyEncryptionMethodGenerator(pub);  
        	encryptedDataGenerator.addMethod(encKeyGen); 
        
        OutputStream encryptedOut = encryptedDataGenerator.open(out, new byte[256]);

        // Initialize compressed data generator
        PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(PGPCompressedData.ZLIB);
        OutputStream compressedOut = compressedDataGenerator.open(encryptedOut, new byte[256]);

        
     // Initialize signature generator
        System.out.println(pub.getAlgorithm());
        JcaPGPContentSignerBuilder signerBuilder = new JcaPGPContentSignerBuilder(pub.getAlgorithm(), PGPUtil.SHA1).setProvider("BC");
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(signerBuilder);
        signatureGenerator.init(PGPSignature.BINARY_DOCUMENT, privateKey);

        Iterator it = pub.getUserIDs();
        if (it.hasNext()) {
        	String id = (String) it.next();
        	System.out.println("Userid: " + id);
            PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
            spGen.setSignerUserID(false, id);
            signatureGenerator.setHashedSubpackets(spGen.generate());
        }
        signatureGenerator.generateOnePassVersion(false).encode(compressedOut);
        PGPSignature sig = signatureGenerator.generate();
        // Initialize literal data generator
        PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
        OutputStream literalOut = literalDataGenerator.open(
            compressedOut,
            PGPLiteralData.BINARY,
            "encrypted.asc",
            new Date(),
            new byte[256]);

        int len;

        while ((len = dataStream.read()) > 0) {
         literalOut.write(len);
         signatureGenerator.update((byte) len);
        }
        literalOut.close();

        // Generate the signature, compress, encrypt and write to the "out" stream
        

        sig.encode(compressedOut);
        compressedOut.close();

        encryptedOut.close();
        
        out.close();
	}
        
private static boolean decodeTest (InputStream in, PGPPrivateKey privateKey, PGPPublicKey pub) throws Exception {

        in = PGPUtil.getDecoderStream(in);

        PGPObjectFactory pgpF = new PGPObjectFactory(in, new BcKeyFingerprintCalculator());
        PGPEncryptedDataList enc;

        Object o = pgpF.nextObject();
        
        if (o == null) {
        	throw new Exception( "No Encrypted items");
        }
        //
        // the first object might be a PGP marker packet.
        //
        Object message = null;
        PGPObjectFactory plainFact = null;
        if (o instanceof PGPEncryptedDataList) {
            enc = (PGPEncryptedDataList) o;
            Iterator<?> it2 = enc.getEncryptedDataObjects();
            
            if (it2.hasNext()) {
            PGPPublicKeyEncryptedData pbe = (PGPPublicKeyEncryptedData) it2.next();
            InputStream clear = pbe.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(privateKey));
             plainFact = new PGPObjectFactory(clear, new BcKeyFingerprintCalculator());
             message = plainFact.nextObject();
            }
        } else {
            message =  o;
            plainFact = pgpF;
        }    

        
        
        PGPOnePassSignatureList onePassSignatureList = null;
        PGPSignatureList signatureList = null;
        PGPCompressedData compressedData = null;

        
        ByteArrayOutputStream actualOutput = new ByteArrayOutputStream();

        while (message != null) {
            if (message instanceof PGPCompressedData) {
                compressedData = (PGPCompressedData) message;
                plainFact = new PGPObjectFactory(compressedData.getDataStream(), new BcKeyFingerprintCalculator());
                message = plainFact.nextObject();
            }

            if (message instanceof PGPLiteralData) {
                // have to read it and keep it somewhere.
                Streams.pipeAll(((PGPLiteralData) message).getInputStream(), actualOutput);
            } else if (message instanceof PGPOnePassSignatureList) {
                onePassSignatureList = (PGPOnePassSignatureList) message;
            } else if (message instanceof PGPSignatureList) {
                signatureList = (PGPSignatureList) message;
            } else {
                
            }
            message = plainFact.nextObject();
        }
        actualOutput.close();
        in.close();
        byte[] output = actualOutput.toByteArray();
        System.out.println("Decoded: " + new String(output));
        
        if (onePassSignatureList == null || signatureList == null) {
            throw new PGPException("Poor PGP. Signatures not found.");
        } else {

            for (int i = 0; i < onePassSignatureList.size(); i++) {
                PGPOnePassSignature ops = onePassSignatureList.get(0);
                System.out.println("verifier : " + ops.getKeyID());
                System.out.println("pubkey : " + pub.getKeyID());
                System.out.println("signature found");
                ops.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pub);
                ops.update(output);
                PGPSignature signature = signatureList.get(i);
                if (ops.verify(signature)) {
                    Iterator<?> userIds = pub.getUserIDs();
                    while (userIds.hasNext()) {
                        String userId = (String) userIds.next();
                        System.out.println("Signed by " + userId);
                    }
                    
                    System.out.println("Signature verified");
                    return(true);
                } else {
                	System.out.println("failed");

                    // throw new SignatureException("Signature verification failed");
                }
        
            }
        }
        return(false);
	}
	
	    private static void verifyFile(
	        InputStream        in,
	        PGPPublicKeyRing pgpRing)
	        throws Exception
	    {
	        in = PGPUtil.getDecoderStream(in);
	        
	        JcaPGPObjectFactory            pgpFact = new JcaPGPObjectFactory(in);

	        PGPCompressedData           c1 = (PGPCompressedData)pgpFact.nextObject();

	        pgpFact = new JcaPGPObjectFactory(c1.getDataStream());
	            
	        PGPOnePassSignatureList     p1 = (PGPOnePassSignatureList)pgpFact.nextObject();
	            
	        PGPOnePassSignature         ops = p1.get(0);
	            
	        PGPLiteralData              p2 = (PGPLiteralData)pgpFact.nextObject();

	        InputStream                 dIn = p2.getInputStream();
	        int                         ch;

	        PGPPublicKey                key = pgpRing.getPublicKey(ops.getKeyID());
	        FileOutputStream            out = new FileOutputStream(p2.getFileName());

	        ops.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), key);
	            
	        while ((ch = dIn.read()) >= 0)
	        {
	            ops.update((byte)ch);
	            out.write(ch);
	        }

	        out.close();
	        
	        PGPSignatureList            p3 = (PGPSignatureList)pgpFact.nextObject();

	        if (ops.verify(p3.get(0)))
	        {
	            System.out.println("signature verified.");
	        }
	        else
	        {
	            System.out.println("signature verification failed.");
	        }
	    }

	    /**
	     * Generate an encapsulated signed file.
	     * 
	     * @param fileName
	     * @param keyIn
	     * @param out
	     * @param pass
	     * @param armor
	     * @throws IOException
	     * @throws NoSuchAlgorithmException
	     * @throws NoSuchProviderException
	     * @throws PGPException
	     * @throws SignatureException
	     */
	    private static void signFile(
	        InputStream     input,
	        OutputStream    out,
	        PGPSecretKey pgpSec,
	        PGPPrivateKey pgpPrivKey,
	        PGPPublicKey pub)
	        throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, SignatureException
	    {
	    	boolean armor = true;
	        if (armor)
	        {
	            out = new ArmoredOutputStream(out);
	        }

	        PGPSignatureGenerator       sGen = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(pgpSec.getPublicKey().getAlgorithm(), PGPUtil.SHA1).setProvider("BC"));
	        
	        sGen.init(PGPSignature.BINARY_DOCUMENT, pgpPrivKey);
	        
	        Iterator    it = pgpSec.getPublicKey().getUserIDs();
	        if (it.hasNext())
	        {
	            PGPSignatureSubpacketGenerator  spGen = new PGPSignatureSubpacketGenerator();
	            
	            spGen.setSignerUserID(false, (String)it.next());
	            sGen.setHashedSubpackets(spGen.generate());
	        }
	        
	        BcPGPDataEncryptorBuilder builder = new BcPGPDataEncryptorBuilder(PGPEncryptedData.AES_256);  
	        builder.setSecureRandom(new SecureRandom());
	        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator(builder); 
	        
	        	BcPublicKeyKeyEncryptionMethodGenerator encKeyGen = new BcPublicKeyKeyEncryptionMethodGenerator(pub);  
	        	encryptedDataGenerator.addMethod(encKeyGen); 
	        	OutputStream encryptedOut = encryptedDataGenerator.open(out, new byte[4028]);
	        	
	        PGPCompressedDataGenerator  cGen = new PGPCompressedDataGenerator(
	                                                                PGPCompressedData.ZLIB);
	        
	        BCPGOutputStream            bOut = new BCPGOutputStream(cGen.open(encryptedOut));
	        
	        sGen.generateOnePassVersion(false).encode(bOut);
	        
	       // File                        file = new File(fileName);
	        PGPLiteralDataGenerator     lGen = new PGPLiteralDataGenerator();
	        OutputStream                lOut = lGen.open(bOut, PGPLiteralData.BINARY, "encrypted.asc", new Date(), new byte[256]);
	 //      FileInputStream             fIn = new FileInputStream(file);
	        int                         ch;
	        
	        while ((ch = input.read()) >= 0)
	        {
	            lOut.write(ch);
	            sGen.update((byte)ch);
	        }

	        lGen.close();

	        sGen.generate().encode(bOut);

	        cGen.close();
	        encryptedOut.close();
	        if (armor)
	        {
	            out.close();
	        }
	    }
}
