package com.openexchange.guard.mailvelope;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;

public class BackupHandler {

    public BackupData decodeBackup (String armored, String passphrase) throws IOException {

        InputStream in = new ByteArrayInputStream(armored.getBytes("UTF-8"));
        in = PGPUtil.getDecoderStream(in);
        PGPObjectFactory pgpF = new PGPObjectFactory(in, new BcKeyFingerprintCalculator());
        PGPEncryptedDataList enc;
        PGPSecretKeyRing ringData = null;
        String password = null;
        //reading first part of the stream
        Object o = pgpF.nextObject();
        while (o != null) {
            //the first object might be a PGP marker packet.
            if (o instanceof PGPEncryptedDataList) {
                enc = (PGPEncryptedDataList) o;
            } else {
                enc = (PGPEncryptedDataList) pgpF.nextObject();
            }
            Iterator<?> it = enc.getEncryptedDataObjects();
            while (it.hasNext()) {
                Object encrObj = it.next();
                if (encrObj instanceof PGPPBEEncryptedData) {
                    PGPPBEEncryptedData sym = (PGPPBEEncryptedData) encrObj;
                    try {
                        final InputStream clear = sym.getDataStream(new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(
                            passphrase.toCharArray()));
                        PGPObjectFactory clearFactory=new PGPObjectFactory(clear, new BcKeyFingerprintCalculator());
                        Object dobject =clearFactory.nextObject();
                        while (dobject != null) {
                            if (dobject instanceof PGPCompressedData) {
                                PGPCompressedData compData=(PGPCompressedData)o;
                                clearFactory=new PGPObjectFactory(compData.getDataStream(), new BcKeyFingerprintCalculator());
                                dobject =clearFactory.nextObject();
                              }
                            if (dobject instanceof PGPLiteralData) {
                                PGPLiteralData literal=(PGPLiteralData) dobject;
                                InputStream lis=literal.getInputStream();
                                final byte[] buffer=new byte[4096];
                                int len;
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                while ((len=lis.read(buffer)) >= 0) {
                                  out.write(buffer,0,len);
                                }
                                String decoded = new String(out.toByteArray());
                                String[] lines = decoded.split("\r");
                                for (String line : lines) {
                                    line = line.replace("\n", "");
                                    if (line.startsWith("Pwd:")) {
                                        password = line.replace("Pwd:", "").trim();
                                    }
                                }
                            }
                            if (dobject instanceof PGPSecretKeyRing) {
                                ringData = (PGPSecretKeyRing) dobject;
                            }
                              
                              dobject =clearFactory.nextObject();
                            }
                        

                    } catch (Exception e) {
                        System.out.println(e);
                    }
                }
            }
            o = pgpF.nextObject();
        }
        if (password != null && ringData != null) {
            return (new BackupData(password, ringData));
        }
        return (null);
    }
}
