package com.openexchange.guard.database.remoteKeyCache;

import java.util.List;
import org.bouncycastle.openpgp.PGPPublicKeyRing;

/**
 * {@link RemoteKeysStorage} provides a storage for remote (HKP resolved) PGP Keys
 */
public interface RemoteKeyCacheStorage {

    /**
     * Deletes cached remote keys which are older than a given amount of days
     * @param days the days
     * @throws Exception due an error
     * @return the amount of deleted keys
     */
    public int deleteOld(int days) throws Exception;

    /**
     * Stores a new Key ring into the remote cache
     * @param keyRing the key ring to store
     * @throws Exception due an error
     */
    public void insert(PGPPublicKeyRing keyRing) throws Exception;

    /**
     * Gets stored pgp key rings by email
     * @param email
     * @return
     * @throws Exception due an error
     */
    public List<PGPPublicKeyRing> getByEmail(String email) throws Exception;
}