package com.openexchange.guard.database.ogPGPKeys;

import java.util.List;

/**
 * {@link OGPGPKeysStorage} provides access to the uploaded keys by a user
 */
public interface OGPGPKeysStorage {

    /**
     * Gets a list of uploaded PGP Keys for a given user
     * @param userId the user's id to retrieve the uploaded keys for
     * @param contextId the user's context Id
     * @param A list of uploaded keys for the given user
     * @throws Exception due an Error
     */
    public List<OGPGPKey> getForUser(int userId, int contextId) throws Exception;

    /**
     *
     * @param userId the user's id to retrieve the uploaded keys for
     * @param contextId the context id
     * @param emails a list of mails to get the keys for
     * @param shard true to query guest-shards storage, false to query ox guard storage
     * @return A list of uploaded keys for the given user matching the given email addresses
     * @throws Exception
     */
    public List<OGPGPKey> getForUserByEmail(int userId, int contextId,List<String> emails,boolean shard) throws Exception;

    /**
     * Gets the uploaded PGP key containing the given email for a certain user
     * @param userId the user to get the uploaded key for
     * @param contextId the context Id
     * @param email the email of the key to retrieve
     * @param keyIds the IDs of the key to retrieve
     * @return The uploaded key related to the given email, or null if no such key was found, or the user is not allowed to access the key
     * @throws Exception due an error
     */
    public OGPGPKey getForUserByEmailAndIds(int userId,int contextId, String email, List<String> keyIds) throws Exception;

    /**
     * Gets the uploaded PGP key containing the given Ids for a certain user
     * (If the key contains more than one email addresses, the storage will have an entry for each)
     * @param userId the user to get the uploaded key for
     * @param contextId the context Id
     * @param keyIds the IDs of the key to retrieve
     * @return The uploaded key related to the given keyIds, or null if no such key was found, or the user is not allowed to access the key
     * @throws Exception due an error
     */
    public List<OGPGPKey> getForUserByIds(int userId, int contextId, List<String>keyIds) throws Exception;

    /**
     * Inserts or updates a uploaded PGP Key entry
     * @param userId the id of the owner of the uploaded key
     * @param contextId the context id of the owner
     * @param email the email related to the public key
     * @param keyIds a list of IDs related to the public key
     * @param ascKeyData the ASCII armored public key data
     * @throws Exception due an error
     */
    public void InsertOrUpdate(int userId, int contextId, String email,List<String>keyIds,String ascKeyData) throws Exception;

    /**
     * Deletes an uploaded key for a user by a list of keyIds
     * @param userId the ID of the user to delete the public key data for
     * @param contextId the context Id
     * @param keyIds the IDs of the key to delete
     * @throws Exception due an error
     */
    public void Delete(int userId,int contextId, List<String>keyIds) throws Exception;

    /**
     * Sets the share-level for an uploaded PGP key
     * TODO: describe what share-level means
     *
     * @param userId the ID of the user who wants to change the share-level
     * @param contextId the context id
     * @param keyIds the IDs of the key to change the share-level for
     * @param shareLevel the new share-level
     * @throws Exception due an error
     */
    public void UpdateShareLevel(int userId, int contextId, List<String>keyIds, int shareLevel) throws Exception;

    /**
     * Sets the inline mode for an uploaded PGP key
     * @param userId The user ID of the user who wants to change the inline mode
     * @param contextId the context id
     * @param keyIds the IDs of the key to change the inline mode for
     * @param useInline Whether to use PGP inline with the given key or not
     * @throws Exception due an error
     */
    public void UpdateInlineMode(int userId, int contextId, List<String> keyIds,boolean useInline) throws Exception;
}
