package com.openexchange.guard.database.ogEmail;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;

public class RestDbOGEmailStorage implements OGEmailStorage {

    private static Logger logger = LoggerFactory.getLogger(RestDbOGEmailStorage.class);

    @Override
    public void insertOrUpdate(String email, int contextId, int userId, int dbShard) throws Exception {
        DbQuery dbQuery = new DbQuery();
        try {
            DbCommand command = new DbCommand(OGEmailSql.INSERT_OR_UPDATE_STMT);
            command.addVariables(email);
            command.addVariables(userId);
            command.addVariables(contextId);
            command.addVariables(dbShard);
            command.addVariables(userId);
            command.addVariables(contextId);
            command.addVariables(dbShard);
            dbQuery.writeOxGuard(command);
        }
        finally {
            dbQuery.close();
        }
    }

    @Override
    public void deleteAllForUser(int contextId, int userId) throws Exception {
        DbQuery dbQuery = new DbQuery();
        try {
            DbCommand command = new DbCommand(OGEmailSql.DELETE_ALL_FOR_USER_STMT);
            command.addVariables(userId);
            command.addVariables(contextId);
            dbQuery.writeOxGuard(command);

        } catch (Exception e) {
            logger.error(
                String.format("Error while deleting ogEmail mapping for user %d in context %d from table deletedKeys: %s",
                              userId,
                              contextId,
                              e.getMessage()));
            e.printStackTrace();
            throw e;
        }
        finally {
            dbQuery.close();
        }
    }

    @Override
    public void deleteAllForContext(int contextId) throws Exception {
        DbQuery db = new DbQuery();
        try {
            DbCommand command = new DbCommand(OGEmailSql.DELETE_ALL_FOR_CONTEXT_STMT);
            command.addVariables(contextId);
            db.writeOxGuard(command);
        }
        finally {
            db.close();
        }
    }

    @Override
    public OGEmail getByEmail(String email) throws Exception {
        DbQuery db = new DbQuery();
        try {
            DbCommand command = new DbCommand(OGEmailSql.SELECT_BY_EMAIL_STMT);
            command.addVariables(email);
            db.readOG(command);
            if(db.next()) {
                return new OGEmail(db.rs.getString("email"),
                                   db.rs.getInt("id"),
                                   db.rs.getInt("cid"),
                                   db.rs.getInt("db"));
            }
            return null;
        }
        finally {
            db.close();
        }
    }

    @Override
    public List<OGEmail> getById(int contextId, int userId) throws Exception {
        DbQuery db = new DbQuery();
        try {
            List<OGEmail> ret = new ArrayList<OGEmail>();
            DbCommand command = new DbCommand(OGEmailSql.SELECT_BY_USERID_STMT);
            command.addVariables(userId);
            command.addVariables(contextId);
            db.readOG(command);
            while(db.next()) {
                ret.add(new OGEmail(db.rs.getString("email"),
                                    db.rs.getInt("id"),
                                    db.rs.getInt("cid"),
                                    db.rs.getInt("db")));
            }
            return ret;
        }
        finally {
            db.close();
        }
    }

    @Override
    public int getHighestGuestId() throws Exception {
        DbQuery db = new DbQuery();
        try {
            DbCommand command = new DbCommand(OGEmailSql.SELECT_HIGHEST_GUEST_USERID_STMT);
            db.readOG(command);
            int max = 1;
            if(db.next() && !db.rs.isNull("MAX(ID)")) {
                max = db.rs.getInt("MAX(ID)");
            }
            return max;
        }
        finally {
            db.close();
        }
    }
}