package com.openexchange.guard.database.ogEmail;

import java.util.List;

/**
 * {@link OGEmailStorage} provides access to stored ogEmail mappings
 */
public interface OGEmailStorage {

    /**
     * Creates a new OGEmail item or updates an item, if there is already an item for the given email
     * @param email the email to create or update the item for
     * @param contextId the context id
     * @param userId the user id
     * @param dbShard the db shard id pointing to the database containing the key information related to this email
     * @throws due an error
     */
    public void insertOrUpdate(String email, int contextId, int userId, int dbShard) throws Exception;

    /**
     * Deletes all ogEmail mappings for a given user
     * @param contextId the context id
     * @param userId the user id to delete the mappings for
     * @throws due an error
     */
    public void deleteAllForUser(int contextId, int userId) throws Exception;

    /**
     * Deletes all ogEmail mappings for a given context
     * @param contextId the context id to delete the mappings for
     * @throws Exception due an error
     */
    public void deleteAllForContext(int contextId) throws Exception;

    /**
     * Gets a mapping for a user's email
     * @param email the email to get the mapping for
     * @return the mapping for the given email, or null if no mapping was found
     */
    public OGEmail getByEmail(String email) throws Exception ;

    /**
     * Gets a list of OGEmail items for a given user
     * @param contextId the context id of the user
     * @param userId the user's id
     * @return a list of OGEmail items for the given user
     * @throws due an error
     */
    public List<OGEmail> getById(int contextId, int userId) throws Exception;

    /**
     * Gets the highest existing user id from all OGEmail entries which context id is < 0 (Guests)
     * @return the highest guest id for all OGEmail entries related to a guest account,
     * @throws Exception due an error
     */
    public int getHighestGuestId() throws Exception;
}

