package com.openexchange.guard.database.fileCache;

import java.util.List;

/**
 * {@link FileCacheStorage} provides access to stored FileCache items
 */
public interface FileCacheStorage {

    /**
     * Gets an item by id
     * @param itemId the item id
     * @return the FileCacheItem for the given itemId
     * @throws Exception due an error
     */
    FileCacheItem getById(String itemId) throws Exception;

    /**
     * Creates a new FileCache item
     * @param itemId the unique id to use for the new item
     * @param userId the owner of the item
     * @param the location of the item on the disk
     * @throws due an error
     */
    public void Insert(String itemId, int userId, String path) throws Exception;

    /**
     * Updates the last access of a FileCache item to "NOW"
     * @param itemId the id of the item to update
     * @throws due an error
     */
    public void updateLastDate(String itemId) throws Exception;

    /**
     * Deletes a FileItem from the cache
     * @param idemId the id of the item to delete
     * @throws Exception due an error
     */
    public void delete(String itemId) throws Exception;

    /**
     * Finds FileCache items which have not been accessed since x days
     * @param days the amount of days
     * @return A list of items which have not been accessed since the given amount of days
     * @throws Exception due an error
     */
    public List<FileCacheItem> findOld(int days) throws Exception;
}