package com.openexchange.guard.database;

import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.config.Config;


public class IdleConnectionMonitor extends Thread {
	private static Logger logger = LoggerFactory.getLogger(IdleConnectionMonitor.class);

	private final HttpClientConnectionManager connMgr;
    private volatile boolean shutdown;
    private int lastcount = 0;
    private final String name;

    public IdleConnectionMonitor
      (PoolingHttpClientConnectionManager connMgr, String name) {
        super();
        this.connMgr = connMgr;
        this.name = name;
    }
    @Override
    public void run() {
        try {
            while (!shutdown) {
                synchronized (this) {
                    wait(2000);
                    getStats();
                    connMgr.closeExpiredConnections();
                    connMgr.closeIdleConnections(Config.OXBackendIdleTime, TimeUnit.SECONDS);
                }
            }
        } catch (InterruptedException ex) {
            shutdown();
        } catch (Exception e) {
        	logger.debug("Error in idle monitor loop" , e);
        }
    }

    public void shutdown() {
        shutdown = true;
        synchronized (this) {
            notifyAll();
        }
    }

    private void getStats () {
    	PoolStats stats = ((PoolingHttpClientConnectionManager) connMgr).getTotalStats();
    	int total = stats.getAvailable() + stats.getLeased();
    	if (total != lastcount) {
    		logger.debug("HTTP " + name + " pool connections- In Pool: " + stats.getAvailable() + " Active: " + stats.getLeased() + " Hold: " + stats.getPending());
    	}
    	lastcount = total;
    }


}
