/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.A6Record;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;

public class A6RecordTest
extends TestCase {
    Name m_an;
    Name m_an2;
    Name m_rn;
    InetAddress m_addr;
    String m_addr_string;
    String m_addr_string_canonical;
    byte[] m_addr_bytes;
    int m_prefix_bits;
    long m_ttl;

    protected void setUp() throws TextParseException, UnknownHostException {
        this.m_an = Name.fromString("My.Absolute.Name.");
        this.m_an2 = Name.fromString("My.Second.Absolute.Name.");
        this.m_rn = Name.fromString("My.Relative.Name");
        this.m_addr_string = "2001:0db8:85a3:08d3:1319:8a2e:0370:7334";
        this.m_addr_string_canonical = "2001:db8:85a3:8d3:1319:8a2e:370:7334";
        this.m_addr = InetAddress.getByName(this.m_addr_string);
        this.m_addr_bytes = this.m_addr.getAddress();
        this.m_ttl = 79225L;
        this.m_prefix_bits = 9;
    }

    public void test_ctor_0arg() {
        A6Record ar = new A6Record();
        A6RecordTest.assertNull((Object)ar.getName());
        A6RecordTest.assertEquals((int)0, (int)ar.getType());
        A6RecordTest.assertEquals((int)0, (int)ar.getDClass());
        A6RecordTest.assertEquals((long)0L, (long)ar.getTTL());
    }

    public void test_getObject() {
        A6Record ar = new A6Record();
        Record r = ar.getObject();
        A6RecordTest.assertTrue((boolean)(r instanceof A6Record));
    }

    public void test_ctor_6arg() {
        A6Record ar = new A6Record(this.m_an, 1, this.m_ttl, this.m_prefix_bits, this.m_addr, null);
        A6RecordTest.assertEquals((Object)this.m_an, (Object)ar.getName());
        A6RecordTest.assertEquals((int)38, (int)ar.getType());
        A6RecordTest.assertEquals((int)1, (int)ar.getDClass());
        A6RecordTest.assertEquals((long)this.m_ttl, (long)ar.getTTL());
        A6RecordTest.assertEquals((int)this.m_prefix_bits, (int)ar.getPrefixBits());
        A6RecordTest.assertEquals((Object)this.m_addr, (Object)ar.getSuffix());
        A6RecordTest.assertNull((Object)ar.getPrefix());
        ar = new A6Record(this.m_an, 1, this.m_ttl, this.m_prefix_bits, this.m_addr, this.m_an2);
        A6RecordTest.assertEquals((Object)this.m_an, (Object)ar.getName());
        A6RecordTest.assertEquals((int)38, (int)ar.getType());
        A6RecordTest.assertEquals((int)1, (int)ar.getDClass());
        A6RecordTest.assertEquals((long)this.m_ttl, (long)ar.getTTL());
        A6RecordTest.assertEquals((int)this.m_prefix_bits, (int)ar.getPrefixBits());
        A6RecordTest.assertEquals((Object)this.m_addr, (Object)ar.getSuffix());
        A6RecordTest.assertEquals((Object)this.m_an2, (Object)ar.getPrefix());
        try {
            new A6Record(this.m_rn, 1, this.m_ttl, this.m_prefix_bits, this.m_addr, null);
            A6RecordTest.fail((String)"RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
        try {
            new A6Record(this.m_an, 1, this.m_ttl, this.m_prefix_bits, this.m_addr, this.m_rn);
            A6RecordTest.fail((String)"RelativeNameException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
        try {
            new A6Record(this.m_rn, 1, this.m_ttl, 256, this.m_addr, null);
            A6RecordTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (RelativeNameException e) {
            // empty catch block
        }
        try {
            new A6Record(this.m_an, 1, this.m_ttl, this.m_prefix_bits, InetAddress.getByName("192.168.0.1"), null);
            A6RecordTest.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (UnknownHostException e) {
            A6RecordTest.fail((String)e.getMessage());
        }
    }

    public void test_rrFromWire() throws CloneNotSupportedException, IOException, UnknownHostException {
        DNSOutput dout = new DNSOutput();
        dout.writeU8(0);
        dout.writeByteArray(this.m_addr_bytes);
        DNSInput din = new DNSInput(dout.toByteArray());
        A6Record ar = new A6Record();
        ar.rrFromWire(din);
        A6RecordTest.assertEquals((int)0, (int)ar.getPrefixBits());
        A6RecordTest.assertEquals((Object)this.m_addr, (Object)ar.getSuffix());
        A6RecordTest.assertNull((Object)ar.getPrefix());
        dout = new DNSOutput();
        dout.writeU8(9);
        dout.writeByteArray(this.m_addr_bytes, 1, 15);
        dout.writeByteArray(this.m_an2.toWire());
        din = new DNSInput(dout.toByteArray());
        ar = new A6Record();
        ar.rrFromWire(din);
        A6RecordTest.assertEquals((int)9, (int)ar.getPrefixBits());
        byte[] addr_bytes = (byte[])this.m_addr_bytes.clone();
        addr_bytes[0] = 0;
        InetAddress exp = InetAddress.getByAddress(addr_bytes);
        A6RecordTest.assertEquals((Object)exp, (Object)ar.getSuffix());
        A6RecordTest.assertEquals((Object)this.m_an2, (Object)ar.getPrefix());
    }

    public void test_rdataFromString() throws CloneNotSupportedException, IOException, UnknownHostException {
        Tokenizer t = new Tokenizer("0 " + this.m_addr_string);
        A6Record ar = new A6Record();
        ar.rdataFromString(t, null);
        A6RecordTest.assertEquals((int)0, (int)ar.getPrefixBits());
        A6RecordTest.assertEquals((Object)this.m_addr, (Object)ar.getSuffix());
        A6RecordTest.assertNull((Object)ar.getPrefix());
        t = new Tokenizer("9 " + this.m_addr_string + " " + this.m_an2);
        ar = new A6Record();
        ar.rdataFromString(t, null);
        A6RecordTest.assertEquals((int)9, (int)ar.getPrefixBits());
        A6RecordTest.assertEquals((Object)this.m_addr, (Object)ar.getSuffix());
        A6RecordTest.assertEquals((Object)this.m_an2, (Object)ar.getPrefix());
        t = new Tokenizer("129");
        ar = new A6Record();
        try {
            ar.rdataFromString(t, null);
            A6RecordTest.fail((String)"TextParseException not thrown");
        }
        catch (TextParseException e) {
            // empty catch block
        }
        t = new Tokenizer("0 " + this.m_addr_string.substring(4));
        ar = new A6Record();
        try {
            ar.rdataFromString(t, null);
            A6RecordTest.fail((String)"TextParseException not thrown");
        }
        catch (TextParseException textParseException) {
            // empty catch block
        }
    }

    public void test_rrToString() {
        A6Record ar = new A6Record(this.m_an, 1, this.m_ttl, this.m_prefix_bits, this.m_addr, this.m_an2);
        String exp = "" + this.m_prefix_bits + " " + this.m_addr_string_canonical + " " + this.m_an2;
        String out = ar.rrToString();
        A6RecordTest.assertEquals((String)exp, (String)out);
    }

    public void test_rrToWire() {
        A6Record ar = new A6Record(this.m_an, 1, this.m_ttl, this.m_prefix_bits, this.m_addr, this.m_an2);
        DNSOutput dout = new DNSOutput();
        dout.writeU8(this.m_prefix_bits);
        dout.writeByteArray(this.m_addr_bytes, 1, 15);
        dout.writeByteArray(this.m_an2.toWireCanonical());
        byte[] exp = dout.toByteArray();
        dout = new DNSOutput();
        ar.rrToWire(dout, null, true);
        A6RecordTest.assertTrue((boolean)Arrays.equals(exp, dout.toByteArray()));
        dout = new DNSOutput();
        dout.writeU8(this.m_prefix_bits);
        dout.writeByteArray(this.m_addr_bytes, 1, 15);
        dout.writeByteArray(this.m_an2.toWire());
        exp = dout.toByteArray();
        dout = new DNSOutput();
        ar.rrToWire(dout, null, false);
        A6RecordTest.assertTrue((boolean)Arrays.equals(exp, dout.toByteArray()));
    }
}

