/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.validator;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.net.telnet.TelnetClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;



/**
 * Validates Email addresses. Simple vs detailed
 *
 * @author greg
 */
public class EmailValidator {

	private static Logger logger = LoggerFactory.getLogger(EmailValidator.class);

    String from = "";

    String location = "";

    String email = "";

    public boolean result = true;

    public String reason = "";

    public EmailValidator(String From, String Email) {
        from = From;
        email = Email;
    }

    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@" + "[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";

    public String mx = "";

    /**
     * Validate an email with regex and mx record
     *
     * @return
     */
    public boolean validate() {
        Pattern pattern = Pattern.compile(EMAIL_PATTERN);
        Matcher matcher = pattern.matcher(email);
        if (!matcher.matches()) {
            reason = "Bad email format";
            return (false);
        }
        String domain = email.substring(email.indexOf("@") + 1);
        try {
            Record[] records = new Lookup(domain, Type.MX).run();
            if (records.length == 0) {
                reason = "No MX Records";
                return (false);
            }
            location = records[0].getAdditionalName().toString();
        } catch (TextParseException e) {
        	logger.error("Error parsing MX record of " + domain, e);
        }
        return (true);
    }

    public static boolean validate(String email) {
    	boolean isValid = false;
    	if (email == null) {
            return(false);
        }
    	if (!email.contains("@")) {
            return(false);
        }
    	try {
    		InternetAddress e = new InternetAddress(email);
    		e.validate();
    		isValid = true;
    	} catch (AddressException e) {
    		System.out.println(e.getMessage());
    	}
    	return (isValid);
    }

    /**
     * Validate email through connection attempt, check accept recipient
     *
     * @return
     */
    public boolean testSMTP() {
        if (location.equals("")) {
            validate();
        }
        TelnetClient tc = new TelnetClient();
        try {
            tc.setConnectTimeout(2000);
            tc.connect(location, 25);
            InputStream in = tc.getInputStream();
            byte[] buff = new byte[1024];
            int read = 0;
            read = in.read(buff);
            PrintStream out = new PrintStream(tc.getOutputStream());
            String command = "EHLO oxguard.com";
            out.println(command);
            out.flush();
            read = in.read(buff);
            String data = new String(buff);
            if (data.contains("550") || data.contains("551")) {
                tc.disconnect();
                reason = "Failed Hello";
                return (false);
            }
            command = "MAIL FROM:<" + from + ">";
            out.println(command);
            out.flush();
            read = in.read(buff);
            data = new String(buff);
            if (data.contains("550") || data.contains("551")) {
                tc.disconnect();
                reason = "Rejected Mail From";
                return (false);
            }
            command = "RCPT TO:<" + email + ">";
            out.println(command);
            out.flush();
            read = in.read(buff);
            data = new String(buff);
            if (data.contains("550") || data.contains("551")) {
                reason = "Rejected recipient";
                tc.disconnect();
                return (false);
            }
            command = "QUIT";
            out.println(command);
            out.flush();
            in.close();
            tc.disconnect();
        } catch (Exception ex) {

        }
        return (true);

    }

    private final ExecutorService executor = Executors.newFixedThreadPool(1);

    public boolean doWork() {
        return (testSMTP());
    }

    public void checkSMTP(int timeoutSecs) {

        final Future<?> future = executor.submit(new Runnable() {

            @Override
            public void run() {
                try {
                    if (!doWork()) {
                        result = false;
                    }
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });

        try {
            future.get(timeoutSecs, TimeUnit.SECONDS);
        } catch (Exception e) {
            logger.debug("Timeout loggin " + location);
            future.cancel(true);
        }
    }

}
