package com.openexchange.guard.setup;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;
import com.openexchange.guard.database.DbStrings;
import com.openexchange.guard.database.OGInit;
import com.openexchange.guard.database.Sharding;
import com.openexchange.guard.server.connectionPooling.HttpConnectionPoolService;

public class Repair {

	private static Logger logger = LoggerFactory.getLogger(Repair.class);

    private final String mysqlIP = com.openexchange.guard.config.Config.getMysqlIP();// IP address of configdb

    private static String mysqlUsername = com.openexchange.guard.config.Config.getMysqlUsername();

    private static String mysqlPassword = com.openexchange.guard.config.Config.getMysqlPassword();

    private static String OGmysqlIP = com.openexchange.guard.config.Config.getMysqlIPOxGuard();

    public static String database_name(int db) {
        return (Config.getShardBaseName()+ db);
    }

	public static void repairShard () throws Exception {
		Class.forName("com.mysql.jdbc.Driver").newInstance();

        String OGmysqlConnectionString = "jdbc:mysql://" + OGmysqlIP + "/?user=" + mysqlUsername + "&password=" + mysqlPassword;
        String OGShardRead = Config.ogMySqlReadIP == null ? null : ("jdbc:mysql://" + Config.ogMySqlReadIP + "/");
        String OgShardWrite = "jdbc:mysql://" + OGmysqlIP + "/";
        Connection intconn = DriverManager.getConnection(OGmysqlConnectionString);
        Connection configdb = DriverManager.getConnection(Config.getConfigDbConnectionString());
        Statement stmt = intconn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT current_shard FROM oxguard.sharding");
        if (rs.next()) {
        	int current = rs.getInt("current_shard");
        	// verify the database is registered
        	logger.info("Trying to re-register shard");
        	RegisterDb.register(configdb, OgShardWrite, OGShardRead, "com.mysql.jdbc.Driver", mysqlUsername, mysqlPassword, database_name(current));
        	intconn.close();
        	//OxDbConn.init();
        	HttpConnectionPoolService.initialize();
            OGInit.initGuardDatabase();
            String dbase = database_name(current);
            DbCommand com = new DbCommand(DbStrings.createKeyTable);
            DbQuery db = new DbQuery();
            try {
                    db.writeToDb(com, dbase);
            } catch (Exception e) {
            	if (e.getMessage().contains("exists")) {
            		logger.info("Table exists ---- OK");
            	} else {
                    logger.error("Failed to create Key Table in shard " + dbase, e);
                }
            }
            try {
                Sharding.setAutoIncr(current);
                logger.info("Shard auto-incrment value updated");
            } catch (Exception e) {
            	logger.error("Failed to set autoincrment value " + dbase, e);
            }
            com = new DbCommand(DbStrings.createContentKeyTable);
            try {
                    db.writeToDb(com, dbase);
                    logger.info("Created contentKeyTable");
            } catch (Exception e) {
            	if (e.getMessage().contains("exists")) {
            		logger.info("Table exists ---- OK");
            	} else {
                    logger.error("Failed to create Content Key Table in shard " + dbase, e);
                }
            }
            com = new DbCommand(DbStrings.createEncryptedTable);
            try {
                    db.writeToDb(com, dbase);
                    logger.info("Created EncryptedTable");
            } catch (Exception e) {
            	if (e.getMessage().contains("exists")) {
            		logger.info("Table exists ---- OK");
            	} else {
                    logger.error("Failed to create Encrypted Object Table in shard " + dbase, e);
                }
            }

        } else {
        	logger.error("Sharding table missing current shard record");
        }
        rs.close();
        stmt.close();
        intconn.close();

	}
}
