package com.openexchange.guard.server;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.google.gson.JsonObject;
import com.openexchange.guard.database.mailvelope.MailvelopeStorage;
import com.openexchange.guard.database.mailvelope.RestDBMailvelopeStorage;
import com.openexchange.guard.mailvelope.PublicKeyImporter;
import com.openexchange.guard.ox.Api;
import com.openexchange.guard.util.Core;

public class MailvelopeService {

    /**
     * Verify logged in and correct context_id
     * @param request
     * @param response
     * @param ck
     * @param cid
     * @return
     */
    private boolean isLogedIn (HttpServletRequest request, HttpServletResponse response, OxCookie ck, int cid) {
        Api ap = new Api(ck, request);
        boolean authorized = ap.verifyLogin();
        if (!authorized) {
            Core.sendFail(response, "Must be logged in");
        } else {
            if (ap.getContextId() != cid) {
                Core.sendFail(response, "Bad id data");
                authorized = false;
            }
        }
        return (authorized);
    }

    public void saveBackup (HttpServletRequest request, HttpServletResponse response, OxCookie ck) throws Exception {
        JsonObject json = Core.getJSON(request);
        int cid = Core.getIntParameter(request, "cid", true);
        if (isLogedIn (request, response, ck, cid)) {
            int userid = Core.getIntParameter(request, "userid", true);
            String data = json.has("data") ? json.get("data").getAsString() : "";
            if (!data.contains("----BEGIN PGP MESSAGE")) {
                Core.sendFail(response, "Missing data");
                return;
            }
            MailvelopeStorage ms = new RestDBMailvelopeStorage();
            if (ms.saveBackupData(data, userid, cid)) {
                Core.sendOK(response, "OK");
            } else {
                Core.sendFail(response, "Fail");
            }

        }
    }

    public void restoreBackup (HttpServletRequest request, HttpServletResponse response, OxCookie ck) throws Exception {
        int cid = Core.getIntParameter(request, "cid", true);
        if (isLogedIn (request, response, ck, cid)) {
            int userid = Core.getIntParameter(request, "userid", true);
            MailvelopeStorage ms = new RestDBMailvelopeStorage();
            String data = ms.getBackupData(userid, cid);
            if (data != null) {
                JsonObject dataJson = new JsonObject();
                dataJson.addProperty("data", data);
                Core.sendJson(response, dataJson);
                return;
            } else {
                Core.sendAnswer(response, 404, "No data");
            }
        }
    }

    public void uploadPublicKey (HttpServletRequest request, HttpServletResponse response, OxCookie ck) throws Exception {
        PublicKeyImporter pki = new PublicKeyImporter();
        pki.importPublicKey(request, response, ck);
    }

}
