package com.openexchange.guard.pgp;

import org.apache.commons.codec.binary.Base64;
import com.openexchange.guard.util.Core;

/**
 * Results from checking signatures of Public Keys
 * @author greg
 *
 */
public class SignatureResults {
    
    String id;
    int result;
    String certifier;
    String imageData;
    int imageType;
    boolean hasImage = false;
    
    public SignatureResults (String _id, int _result, String _certifier) {
        id = _id;
        result = _result;
        certifier = _certifier;
    }
    
    public SignatureResults (String _id, int _result, long _certifier) {
        id = _id;
        result = _result;
        if (_certifier == 0) {
            certifier = "0";
        } else
            certifier = Core.getHex(Long.toString(_certifier));
    }
    
    /**
     * Check if result was valid
     * @return
     */
    public boolean isValid () {
        return (result == -1);
    }
    
    /**
     * Get level of signature
     * @return
     */
    public String getLevel () {
        return (PgpKeys.getSignatureType(result));
    }
    
    /**
     * Return who certified
     * @return
     */
    public String getCertifier () {
        return (certifier);
    }
    
    /**
     * Return Id of the key verified
     * @return
     */
    public String getIdVerified () {
        return (id);
    }
    
    /**
     * Set the image data from vector
     * @param imagedata
     */
    public void setImage (byte [] imagedata) {
        imageData = Base64.encodeBase64String(imagedata);
        hasImage = true;
    }
    
    /**
     * Get base64 image data
     * @return
     */
    public String getBase64Image () {
        return(imageData);
    }
    
    /**
     * Return base64 image data for jpg html image
     * @return
     */
    public String getEmbeddedImage () {
        return ("data:image/jpg;base64," + imageData);
    }
    
    /**
     * Set the image type
     * @param image
     */
    public void setImageType (int image) {
        imageType = image;
    }

    public int getImageType () {
        return (imageType);
    }
    
    /**
     * Return true if has image
     * @return
     */
    public boolean hasImage() {
        return (hasImage);
    }
}
