package com.openexchange.guard.ox.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Utility class for various stream based encryption/decryption tasks
 */

public class GuardStreamUtils  {

    /**
     * Copies an inputStream to an output stream while encrypting/decrypting the input stream's data
     * @param inputStream The input stream
     * @param outputStream the output stream
     * @param streamHandler The stream handler defining the operation to apply on the data while copied
     * @throws IOException
     */
    public static void Copy(InputStream inputStream,
                            OutputStream outputStream,
                            StreamHandler streamHandler) throws IOException{
        streamHandler.processStream(inputStream, outputStream, 2056);
    }
}