/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.encr;

import java.io.IOException;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.sql.SQLException;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.openssl.PEMWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.keyCache.KeyCacheStorage;
import com.openexchange.guard.database.keyCache.RestDbKeyCacheStorage;

public class PopulateRSA implements Runnable  {

	private static Logger logger = LoggerFactory.getLogger(PopulateRSA.class);

    public boolean running = true;

    @Override
    public void run() {
    	if (Config.keyCacheCheckInterval == 0) {
    		logger.info("KeyCacheCheckInterval set to 0.  Exiting RSA cache generator");
    		return;
    	}
    	int idletime = Config.keyCacheCheckInterval * 1000;
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {

                    //TODO: use a ServiceLocator or DI Container to resolve this
                    KeyCacheStorage keyCacheStorage = new RestDbKeyCacheStorage();

                    int count = keyCacheStorage.getCount();
                    if (count < Config.rsa_cache_count) {
                        while (count < Config.rsa_cache_count) {
                            count++;
                            String newkey = genKeyPair();
                            storekey(newkey);
                        }
                    }
                } catch (Exception e) {
                    logger.error("Unable to access key_cache table.  Check database permissions", e);
                }
                Thread.sleep(idletime);
            }
        } catch (Exception ex) {
            logger.info("Keygenerator shutdown");;

        }
    }

    /**
     * Store RSA key PEM for future use.  Encrypt with Config.rpass
     * @param keyAsc the ascii armored to to save
     * @throws SQLException due an error
     */
    private void storekey(String keyAsc) throws SQLException {
        try {
            //encrypting the key for storing it in the DB
            EncrLib encr = new EncrLib();
            keyAsc = encr.encryptAES(keyAsc, Config.rpass, "key", Config.AESKeyLen);

            //TODO: use service locator / DI container for resolving
            KeyCacheStorage keyCacheStorage = new RestDbKeyCacheStorage();
            keyCacheStorage.insert(keyAsc);
        } catch (Exception ex) {
            logger.error("Error while storing key", ex);
        }
    }
    /**
     * Generate RSA keypair and return as PEM
     * @return
     * @throws IOException
     * @throws NoSuchAlgorithmException
     * @throws InvalidKeySpecException
     * @throws NoSuchProviderException
     */
    public static String genKeyPair() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {

    	 RSAKeyPairGenerator kpgen = new RSAKeyPairGenerator();
         kpgen.init(new RSAKeyGenerationParameters(BigInteger.valueOf(0x10001), new SecureRandom(), Config.RSAKeyLen, Config.rsa_certainty));
         AsymmetricCipherKeyPair kp = kpgen.generateKeyPair();
         RSAPrivateCrtKeyParameters rsapckp =
                 (RSAPrivateCrtKeyParameters) kp.getPrivate();

         RSAKeyParameters rsakp = (RSAKeyParameters) kp.getPublic();

         KeyFactory fact = KeyFactory.getInstance("RSA", "BC");

         RSAPrivateCrtKeySpec prvKeySpecs =
                 new RSAPrivateCrtKeySpec(rsapckp.getModulus(),
                 rsapckp.getPublicExponent(), rsapckp.getExponent(),
                 rsapckp.getP(), rsapckp.getQ(), rsapckp.getDP(),
                 rsapckp.getDQ(), rsapckp.getQInv());

         PrivateKey privateKey = fact.generatePrivate(prvKeySpecs);

         RSAPublicKeySpec pubKeySpecs =
                 new RSAPublicKeySpec(rsakp.getModulus(), rsakp.getExponent());
         PublicKey publicKey = fact.generatePublic(pubKeySpecs);

         KeyPair newkp = new KeyPair(publicKey, privateKey);
         // Export
         StringWriter writer = new StringWriter();
         PEMWriter wr = new PEMWriter(writer);
         wr.writeObject(newkp);
         wr.flush();
         wr.close();
         logger.debug("Key generated for cache");
         return (writer.toString());

    }


}
