package com.openexchange.guard.database.userInfo;

import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;

public class RestDbUserInfo implements UserInfo {

    @Override
    public int getConfiguration(int userid, int cid) throws Exception {
        DbQuery db = new DbQuery();
        int result = 0;
        try {
            DbCommand command = new DbCommand(UserInfoSql.SELECT_PERMISSION);
            command.addVariables(cid);
            command.addVariables(userid);
            db.readFromDB(command, cid);
            if(db.next()) {
                result = db.rs.getInt("permissions"); 
            }
        }
        finally {
            db.close();
        }
        return (result);
    }

    @Override
    public boolean hasWebmail(int userid, int cid) throws Exception {
        return ((getConfiguration (userid, cid) & 0x01) > 0);
    }

}
