package com.openexchange.guard.database.oxguardSession;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;


/**
 * {@link RestDbOXGuardSessionStorage} provides a REST DB implementation of the {@link OXGuardSessionStorage}
 */
public class RestDbOXGuardSessionStorage implements OXGuardSessionStorage {

    private static Logger logger = LoggerFactory.getLogger(RestDbOXGuardSessionStorage.class);

    private String convertDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("parameter date must not be null");
        }
        SimpleDateFormat sdf = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    @Override
    public void InsertOrUpdate(String sessionId, String token, int userId, int contextId) throws Exception {
        DbQuery db = new DbQuery();
        try {
            String now = convertDate(new Date());
            DbCommand command = new DbCommand(OXGuardSessionSql.INSERT_STMT);
            //Insert
            command.addVariables(sessionId);
            command.addVariables(token);
            command.addVariables(now);
            command.addVariables(userId);
            command.addVariables(contextId);
            //on duplicated key update
            command.addVariables(sessionId);
            command.addVariables(token);
            command.addVariables(now);

            db.writeOxGuard(command);
        }
        catch(Exception e){
            logger.error("Error while inserting/updating session with id " + sessionId, e);
            throw e;
        }
        finally {
            db.close();
        }
    }

    @Override
    public OXGuardSession getById(String sessionId) {
        DbQuery db = new DbQuery();
        try {
            DbCommand com = new DbCommand(OXGuardSessionSql.SELECT_STMT);
            com.addVariables(sessionId);
            db.readOG(com);
            if (db.next()) {
                return new OXGuardSession(db.rs.getString("sessionid"),
                                          db.rs.getString("token"),
                                          db.rs.getDate("date"),
                                          db.rs.getInt("userid"),
                                          db.rs.getInt("cid"));
            }
        }
        catch(Exception e) {
            logger.error("Error while retrieving token from session " + sessionId, e);
        }
        finally {
            db.close();
        }
        return null;
    }

    @Override
    public void deleteById(String sessionId) throws Exception {
        DbQuery db = new DbQuery();
        try{
            DbCommand command = new DbCommand(OXGuardSessionSql.DELETE_BY_ID_STMT);
            command.addVariables(sessionId);
            db.writeOxGuard(command);
        }
        catch(Exception e) {
            logger.error("Error while deleting oxguard session " + sessionId, e);
            throw e;
        }
        finally {
            db.close();
        }
    }

    @Override
    public void deleteOldSessions(int days) throws Exception {
        DbQuery db = new DbQuery();
        try{
            DbCommand command  = new DbCommand(OXGuardSessionSql.DELETE_OLD_STMT);
            command.addVariables(days);
            db.writeOxGuard(command);
        }
        catch(Exception e) {
            logger.error("Error while deleting old oxguard session older than " + days + " days", e);
            throw e;
        }
        finally {
            db.close();
        }
    }
}
