package com.openexchange.guard.database.oxguardSession;


/**
 * {@link OXGuardSessionStorage} provides access to stored OX Guard session information
 */
public interface OXGuardSessionStorage {

    /**
     * Creates or updates a new session
     * @param sessionId the session to create
     * @param token the authentication token
     * @param userId the userId
     * @param contextId the contextId
     */
    public void InsertOrUpdate(String sessionId, String token, int userId, int contextId) throws Exception;

    /**
     * Get's a session by id
     * @param sessionId the session id
     * @return the session for the given sessionId or null if no such session was found or an error occurred
     */
    public OXGuardSession getById(String sessionId);

    /**
     * Deletes a session
     * @param sessionId the id of the session to delete
     */
    public void deleteById(String sessionId) throws Exception;

    /**
     * Deletes sessions which are older than x days
     * @param days the days
     */
    public void deleteOldSessions(int days) throws Exception;
}
