package com.openexchange.guard.database.oxguardSession;

import java.util.Date;

/**
 * {@link OXGuardSession} represents a OX Guard session
 */
public class OXGuardSession {

    private final String sessionId;
    private final String token;
    private final Date date;
    private final int userId;
    private final int contextId;

    /**
     * Initializes a new {@link OXGuardSession}.
     * @param sessionId the Appsuite session id
     * @param token the ox guard authentication token
     * @param date the creation date of the session
     * @param userId the related user id
     * @param contextId the related context id
     */
    public OXGuardSession(String sessionId, String token, Date date, int userId, int contextId) {
        super();
        this.sessionId = sessionId;
        this.token = token;
        this.date = date;
        this.userId = userId;
        this.contextId = contextId;
    }

    /**
     * @return the related user id
     */
    public int getUserId() {
        return userId;
    }

    /**
     * @return the Appsuite session id
     */
    public String getSessionId() {
        return sessionId;
    }

    /**
     * @return the OX Guard authentication token
     */
    public String getToken() {
        return token;
    }

    /**
     * @return The creation date of the session
     */
    public Date getDate() {
        return date;
    }

    /**
     * @return the related context id
     */
    public int getContextId() {
        return contextId;
    }
}
