package com.openexchange.guard.database.mailvelope;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;

public class RestDBMailvelopeStorage implements MailvelopeStorage {

    private static Logger logger = LoggerFactory.getLogger(RestDBMailvelopeStorage.class);
    @Override
    public boolean saveBackupData(String data, int userid, int cid) {
        DbCommand com = new DbCommand(MailvelopeStorageSql.updateBackup);
        com.addVariables(userid);
        com.addVariables(cid);
        com.addVariables(data);
        com.addVariables(data);
        DbQuery db = new DbQuery();
        try {
            db.writeToDB(com, cid);
        } catch (Exception e) {
            logger.error("Problem updating mailvelope data ", e);
            return (false);
        } finally {
            db.close();
        }

        return true;
    }

    @Override
    public String getBackupData(int userid, int cid) {
        DbCommand com = new DbCommand(MailvelopeStorageSql.getBackupData);
        com.addVariables(userid);
        com.addVariables(cid);
        String data = null;
        DbQuery db = new DbQuery();
        try {
            db.readFromDB(com, cid);
            if (db.next()) {
                data = db.rs.getString("keydata");
            }
        } catch (Exception e) {
            logger.error("Problem reading mailvelope data ", e);
        } finally {
            db.close();
        }
        return (data);
    }

}
