package com.openexchange.guard.database.globalSettings;

/**
 * {@link GlobalSettingsStorage} provides access to stored key-value based settings
 */
public interface GlobalSettingsStorage {

    /**
     * Gets the value for a given key
     * @param key the key
     * @return the key's value
     */
    public String getByKey(String key) throws Exception;

    /**
     * Updates a key's value
     * @param the key to update
     * @param value the new value
     */
    public void Update(String key, String value) throws Exception;
}