package com.openexchange.guard.database.deletedKey;

import java.util.ArrayList;
import java.util.Date;

/**
 * {@link DeletedKeysStorage} provides access to backed up deleted keys
 */
public interface DeletedKeysStorage {

    /**
     * Inserts keys into the storage
     * @param deletedKeys The keys to insert
     * @throws Exception due an error
     */
    public void insert(DeletedKey...deletedKeys) throws Exception;

    /**
     * Exposes every deleted key for a user for downloading by setting the exposed
     * @param email The email of the keys to expose
     * @param cid Context id
     * @throws Exception On error during DB access
     */
    public void setExposedForEmail(String email, int cid) throws Exception;

    /**
     * Gets the first deleted key for a user
     * @param email the email of the user to the get the deleted key's salt
     * @param cid the context id
     * @return the salt of the first found deleted key of the given user
     * @throws Exception On error during DB access
     */
    public DeletedKey getFirstForEmail(String email,int cid) throws Exception;

    /**
     * Removes the exposed flag from all deleted keys which have been exposed before the given date
     * @param before the date to
     * @throws Exception On error updating the DB
     * @return the number of keys which have been reset to "unexposed"
     */
    public int setAllUnexposed(Date before) throws Exception;

    /**
     * Gets a list of all deleted keys for the user, most recent first
     * @param email
     * @param id
     * @param cid
     * @return
     * @throws Exception
     */
    public ArrayList<DeletedKey> getAllExposedForEmail (String email, int id, int cid) throws Exception;
}