/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.database;

import java.security.PublicKey;
import javax.mail.Message.RecipientType;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import com.google.gson.JsonObject;
import com.openexchange.guard.encr.GuardKeys;
import com.openexchange.guard.pgp.PgpKeys;

public class RecipKey {

    public int userid;

    public int cid;

    public PublicKey pubkey;

    public boolean guest;

    public String newGuestPass;

    public String name;

    public RecipientType type;

    public String lang;

    public String email;

    public boolean pgp;

    public boolean expired;

    public boolean inline;

    public PGPPublicKeyRing pgpring;

    public JsonObject settings;

    public RecipKey() {
        guest = false;
        userid = 0;
        pubkey = null;
        newGuestPass = null;
        pgp = false;
        pgpring = null;
        expired = false;
        inline = false;
        settings = new JsonObject();
    }

	public RecipKey(GuardKeys key) {
		guest = false;
        userid = key.userid;
        inline = key.inline;
        pubkey = null;
        newGuestPass = null;
        pgp = true;
        pgpring = key.pubring;
        email = key.email;
        cid = key.contextid;
        expired = PgpKeys.checkAllExpired(key.pubring);
        settings = key.settings;
	}

	/**
	 * A remote key is a key which does not belong to an OX user but to an external recipient
	 * @return Whether the key belongs to an external PGP user or not
	 */
	public boolean isRemoteKey() {
	    return cid == 0;
	}
	   /**
     * Check if the user settings require inline
     * @param settings
     * @return
     */
    public boolean reqInline () {
        if (inline) {
            return(true);
        }
        if (settings == null) {
            return (false);
        }
        if (settings.has("inline")) {
            return (settings.get("inline").getAsBoolean());
        }
        return (false);
    }

}
