/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.openexchange.guard.server.connectionPooling.HttpConnectionPoolService;

/**
 * Retrieve capabilities information from backend
 * @author greg
 *
 */
public class Capabilities {

	private static Logger logger = LoggerFactory.getLogger(Capabilities.class);

    /**
     * Get Json Array of capabilities
     * @param url
     * @return
     * @throws Exception
     */
    private JsonArray getQuietOgRequest(String url) throws Exception {

        JsonArray result = null;
        //CloseableHttpClient httpClient = OxDbConn.httpClient;
        CloseableHttpClient httpClient = HttpConnectionPoolService.getClient();
        HttpContext context = HttpClientContext.create();
        HttpGet getRequest = new HttpGet(url);
        getRequest.addHeader("accept", "application/json");
        getRequest.addHeader("Authorization", "Basic " + Config.getBasicAuthenticationEncoding());
        getRequest.setHeader("User-Agent", Config.apiUserAgent);
        CloseableHttpResponse response = httpClient.execute(getRequest, context);
        if (response.getStatusLine().getStatusCode() != 200) {
            try {
                EntityUtils.consume(response.getEntity());
                getRequest.releaseConnection();
                response.close();
            } catch (Exception e2) {
                logger.error("unable to close http stream after error", e2);
            }
            String resp = response.getStatusLine().getReasonPhrase();
            logger.debug("Unable to get user capabilities from backend " + response.getStatusLine().getReasonPhrase());
            logger.error(resp);
            throw new Exception("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
        JsonParser parser = new JsonParser();
        result = (JsonArray) parser.parse(reader);
        reader.close();
        EntityUtils.consume(response.getEntity());
        response.close();
        getRequest.releaseConnection();
        return (result);

    }

    /**
     * Get a full JSON Array of all capabilities for a user
     * @param id  id of the user
     * @param cid context of the user
     * @return
     * @throws Exception
     */
    public JsonArray getOtherUserCapabilities (int id, int cid) throws Exception {
        String parameters = cid + "/" + id;
        String url = "http" + (Config.backend_ssl ? "s" : "") + "://" + Config.getOxBackend() + ":" + Config.ox_backend_port + "/preliminary/capabilities/v1/all/" + parameters;
        return(getQuietOgRequest(url));
    }

    /**
     * Check if the user has a given capability
     * @param capability  String of the capability (the id)
     * @param id  id of the user
     * @param cid context of the user
     * @return
     * @throws Exception
     */
    public boolean hasUserCapability (String capability, int id, int cid) throws Exception {
        JsonArray capabilities = getOtherUserCapabilities (id, cid);
        boolean found = false;
        for (int i = 0; i < capabilities.size(); i++) {
            JsonObject cap = capabilities.get(i).getAsJsonObject();
            if (cap.has("id")) {
                if (cap.get("id").getAsString().equals(capability)) return (true);
            }
        }
        return (found);
    }

}
