/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2013 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.ant;

import static org.junit.Assert.assertEquals;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Test;
import com.openexchange.obs.api.Code;

/**
 * Tests methods in the {@link Tools} class.
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public class ToolsTest {

    public ToolsTest() {
        super();
    }

    /**
     * Test method for {@link com.openexchange.ant.Tools#split(java.lang.String, char)}.
     */
    @Test
    public void testSplitWithEmptyString() {
        Collection<String> toTest = Tools.split("", ',');
        assertEquals("Returned collection should be empty.", 0, toTest.size());
    }

    /**
     * Test method for {@link com.openexchange.ant.Tools#split(java.lang.String, char)}.
     */
    @Test
    public void testSplitWithSingleEntry() {
        Collection<String> toTest = Tools.split("testo", ',');
        assertEquals("Returned collection contain one element.", 1, toTest.size());
        assertEquals("Single element is not correctly detected.", "testo", toTest.toArray(new String[1])[0]);
    }

    /**
     * Test method for {@link com.openexchange.ant.Tools#split(java.lang.String, char)}.
     */
    @Test
    public void testSplitWithTwoEntries() {
        Collection<String> toTest = Tools.split("test1,test2", ',');
        assertEquals("Returned collection contain two elements.", 2, toTest.size());
        assertEquals("First element is wrong.", "test1", toTest.toArray(new String[2])[0]);
        assertEquals("Second element is wrong.", "test2", toTest.toArray(new String[2])[1]);
    }

    /**
     * Test method for {@link com.openexchange.ant.Tools#split(java.lang.String, char)}.
     */
    @Test
    public void testSplitWithThreeEntries() {
        Collection<String> toTest = Tools.split("test1,test2,test3", ',');
        assertEquals("Returned collection contain two elements.", 3, toTest.size());
        assertEquals("First element is wrong.", "test1", toTest.toArray(new String[3])[0]);
        assertEquals("Second element is wrong.", "test2", toTest.toArray(new String[3])[1]);
        assertEquals("Third element is wrong.", "test3", toTest.toArray(new String[3])[2]);
    }

    /**
     * Test method for {@link com.openexchange.ant.Tools#split(java.lang.String, char)}.
     */
    @Test
    public void testSplitWithThreeEntriesAndOneEmpty() {
        Collection<String> toTest = Tools.split("test1,,test2", ',');
        assertEquals("Returned collection contain two elements.", 3, toTest.size());
        assertEquals("First element is wrong.", "test1", toTest.toArray(new String[3])[0]);
        assertEquals("Second element is wrong.", "", toTest.toArray(new String[3])[1]);
        assertEquals("Third element is wrong.", "test2", toTest.toArray(new String[3])[2]);
    }

    /**
     * Test method for {@link com.openexchange.ant.Tools#join(Collection, String)}.
     */
    @Test
    public void testJoin() {
        List<Code> codes = new ArrayList<Code>();
        codes.add(Code.SUCCEEDED);
        codes.add(Code.FAILED);
        String toTest = Tools.join(codes, ",");
        assertEquals("Joining collections does not work.", "succeeded,failed", toTest);
    }

    private static String testJoinWithVarArgsHelper(Code... codes) {
        return Tools.join(",", codes);
    }

    @Test
    public void testJoinWithVarArgs() {
        assertEquals("succeeded,failed", testJoinWithVarArgsHelper(Code.SUCCEEDED, Code.FAILED));
    }
}
