define('pgp_mail/toggle-encryption', ['pgp_mail/util', 'mailvelope/main', 'gettext!oxguard'
], function (util, mailvelope, gt) {
    'use strict';

    var forced = false;

    var ToggleEncryptionView = Backbone.View.extend({
        initialize: function () {
            this.listenTo(this.model, 'change:encrypt', function (model, val) {
                this.$('i.fa').toggleClass('encrypted', val);
                //gt('Click to enable encryption')
                //gt('Click to disable encryption')
            });
        },
        className: 'toggle-encryption',
        events: {
            'click i.fa': 'toggle'
        },
        toggle: function () {
            if (forced) {
                require (['io.ox/core/notifications'], function (notify) {
                    notify.yell('error', gt('Reply must be encrypted'));
                });
            } else
                this.model.set('encrypt', !this.model.get('encrypt'));
        },
        forceLock: function () {
            forced = true;
            this.model.set('encrypt', true);
        },
        render: function () {
            if (!util.isEncryptEnabled()) return this;
            if (util.mailvelopeSelected() && !mailvelope.isMailvelopeSupported()) return this;
            this.$el.empty().append(
                $('<i class="fa fa-2x">')
                    .toggleClass('encrypted', !!this.model.get('encrypt'))
            );

            return this;
        }
    });

    return {
        View: ToggleEncryptionView
    };
});
