define('pgp_mail/key_fetcher', [
    'oxguard/core/og_http',
    'mailvelope/main',
    'gettext!oxguard'
], function (http, api, gt) {
    'use strict';

    var checking = [];

    function checkKey (email) {
        if (checking.indexOf(email) > -1) return ($.Deferred().reject());
        checking.push(email);
        return (getKey(email, false));
    }

    function downloadKey (email) {
        return (getKey(email, true));
    }

    // Query Guard server for PGP keys.  Get key if download, else get info on keys
    function getKey (email, download) {
        var def = $.Deferred();
        var params = '&email=' + email +
        '&cid=' + ox.context_id +
        '&userid=' + ox.user_id +
        (download === true ? '&download=true' : '') +
        '&session=' + ox.session;

        http.get(ox.apiRoot + '/oxguard/mail?action=getpublic', params)
        .done(function (respData) {
            if (respData !== '') {
                var data;
                if (typeof respData === 'string') {
                    data = JSON.parse(respData).data;
                } else {
                    data = respData.data;
                }
                if (data === 'guest') {
                    def.reject();
                }
                if (data === '') {
                    def.reject();
                }
                def.resolve(data);
                return;
            }
            def.reject();
        })
        .fail(function () {
            def.reject();
        })
        .always(function () {
            // checking.pop(email);
        });
        return (def);
    }

    function promptKeyImport (data, email) {
        var def = $.Deferred();
        require (['io.ox/core/tk/dialogs', 'oxguard/pgp/publickeys'], function (dialogs, publickeys) {
            var dialog = new dialogs.CreateDialog({ width: 450, height: 450, center: true,  enter: 'ok' });
            dialog.header($('<h4>').text(gt('Key found for %1$s.  Import?', email)));
            var keydetail = publickeys.keyDetail(data);
            dialog.getBody().append(keydetail.div);
            dialog.addPrimaryButton('import', gt('Import'), 'import')
            .addButton('cancel', gt('Cancel'), 'cancel')
            .on('import', function () {
                downloadKey (email).done(function (data) {
                    def.resolve(data);
                })
                .fail (function () {
                    def.reject();
                });
            })
            .on('cancel', function () {
                def.reject();
            })
            .show();
        });
        return (def);
    }

    // Query remote server for email and display import dialog if available
    function checkRemote (email) {
        var def = $.Deferred();
        require(['io.ox/core/notifications'], function (notify) {
            try {
                checkKey(email)
                .done(function (data) {
                    promptKeyImport(data, email)
                    .done(function (keydata) {
                        api.getKeyring().then(function (keyring) {
                            keyring.importPublicKey(keydata)
                            .then(function (e) {
                                var result = [{
                                    'Fingerprint': data[0].Fingerprint
                                }];
                                var result = gt('Imported');
                                var success = false;
                                switch (e) {
                                case 'IMPORTED':
                                    success = true;
                                    break;
                                case 'UPDATED':
                                    result = gt('Updated');
                                    success = true;
                                    break;
                                case 'INVALIDATED':
                                    result = gt('Invalidated');
                                    break;
                                case 'REJECTED':
                                    result = gt('Rejected');
                                    break;
                                }
                                if (success) {
                                    def.resolve(result);
                                } else {
                                    def.reject();
                                }
                                notify.yell('success', result);
                            }, function (e) {
                                notify.yell('error', e);
                                def.reject();
                            });
                        });
                    })
                    .fail (function () {
                        def.reject();
                    });
                })
                .fail (function () {
                    def.reject();
                });
            } catch (e) {
                console.log(e);
            }
        });
        return (def);
    }

    return {
        checkKey: checkKey,
        downloadKey: downloadKey,
        promptKeyImport: promptKeyImport,
        checkRemote: checkRemote
    };

});
