define('oxguard/settings/pane', [
    'io.ox/core/extensions',
    'io.ox/core/tk/dialogs',
    'oxguard/crypto/encr',
    'oxguard/core/og_http',
    'oxguard/util',
    'io.ox/backbone/mini-views/help',
    'gettext!oxguard',
    'settings!oxguard'
], function (ext, dialogs, encr, og_http, util, HelpView, gt, settings) {
    'use strict';

    function setupGuard (where) {
        var passheader =
            $('<div class="oxguard_settings"/>')
            .append('<legend class="sectiontitle">' + gt('Get Started') + '</legend></br>');
        var instructions = $('<div>');
        instructions.append('<p>' + gt('In order to start with Guard Security, you must set up a password for your secured files.') + '</p>');
        var startButton = $('<button type="button" class="btn btn-primary">' + gt('Start') + '</button>');
        startButton.click (function () {
            require(['oxguard/oxguard_core'], function (oxguard) {
                oxguard.createKeysWizard()
                .done(function (result) {
                    if (result === 'OK') draw(where);
                    //$('.oxguard_settings').replaceWith(addSettings());
                });
            });
        });
        var holder = $('<div>').css('max-width', '800px');
        holder.append('<h1>' + gt('Guard Security Settings') + '</h1><br/>');
        where.append(holder.append(passheader.append(instructions).append(startButton)));
    }

    function createPasswordChange() {
        var passheader =
        $('<div class="oxguard_settings password"/>')
        .append('<legend class="sectiontitle">' + gt('Password') + '</legend></br>')
        .append('<span> ' + gt('Change Guard Security Password.') + '</span><br/>');
        var newpass1 = $('<input type="password" name="newpass1"/>');
        var td = $('<td>').append(newpass1);
        var newpass2 = $('<input type="password" name="newpass2"/>');
        var td2 = $('<td>').append(newpass2);
        var hint = $('<td>');
        var passwordTable = $('<table/>')
        .append('<tr><td><span>' + gt('Enter current Guard security password') + ': </span></td><td><input type="password" name="oldpass" /><td><td></td></tr>')
        .append($('<tr><td><span>' + gt('Enter new Guard security password') + ': </span></td></tr>').append(td).append(hint))
        .append($('<tr><td><span>' + gt('Verify new Guard security password') + ':</span></td></tr>').append(td2).append('<td></td>'));
        var errorDiv = $('<div id="grdsettingerror" class="alert alert-info" style="display:none"/>');
        require (['oxguard/core/passwords'], function (pass) {
            pass.passwordCheck(newpass1, hint);
            pass.passwordCompare(newpass2, newpass1, hint);
        });
        var passButton = $('<button type="button" class="btn btn-primary">' + gt('Change Guard security password') + '</button>');
        passButton.click(passChanged);

        return (passheader.append(passwordTable).append(errorDiv).append(passButton));
    }

    function createPasswordReset() {
        if (!window.oxguarddata.recovery) {  // If no recovery avail, then don't display reset button
            return ('');
        }
        var passheader =
            $('<div class="oxguard_settings password password-reset"/>')
            .append('<legend class="sectiontitle">' + gt('Reset Guard security password') + '</legend></br>')
            .append('<span> ' + gt('Send a temporary Guard security password to my secondary Email address.') + '</span><br/>');
        var passButton = $('<button type="button" class="btn btn-primary">' + gt('Reset Guard security password') + '</button>');
        passButton.click(doReset);
        return (passheader.append(passButton));
    }

    function createDeleteRecovery() {
        if (window.oxguarddata.settings.noDeleteRecovery || !window.oxguarddata.recovery) {
            return ('');
        }
        var header = $('<div class="oxguard_settings"/>')
            .append('<legend class="sectiontitle">' + gt('Delete Password Recovery') + '</legend></br>')
            .append('<b>' + gt('Advanced Users Only!') + '</b><br>')
            .append('<span> ' + gt('Delete the password recovery.  The recovery is used to reset your password.  If you delete the recovery, you will not be able to reset your password if you forget it.  Changing your password will restore the recovery.') + '</span><br/>');
        var deleteRecoveryButton = $('<button type="button" class="btn btn-primary">' + gt('Delete Password Recovery') + '</button>');
        deleteRecoveryButton.click(doDeleteRecovery);
        return (header.append(deleteRecoveryButton));
    }

    function doDeleteRecovery() {
        require (['oxguard/oxguard_core', 'io.ox/core/notifications'], function (core, notify) {
            core.getPassword(gt('Please verify your password before deleting the recovery'))
            .done (function (e) {
                var data = {
                    userid: ox.user_id,
                    cid: ox.context_id,
                    password: e
                };
                og_http.post(ox.apiRoot + '/oxguard/login?action=deleterecovery&session=' + ox.session, '', data)
                .done (function () {
                    notify.yell('success', gt('Recovery deleted'));
                    window.oxguarddata.recovery = false;
                    redraw();
                })
                .fail (function (e) {
                    if (e.responseText.trim() === 'Bad password') {
                        notify.yell('error', gt('Bad Password'));
                    } else {
                        notify.yell('error', e.responseText);
                    }
                });
            });
        });
    }

    function createSecondaryChange() {
        if (window.oxguarddata.settings.noRecovery === true || window.oxguarddata.recovery === false) return;  // Don't display secondary email if no recovery is set
        updateEmail();
        var emailheader =
            $('<div class="oxguard_settings"/>')
            .append('<legend class="sectiontitle">' + gt('Secondary Email') + '</legend></br>')
            .append('<span> ' + gt('Change Email address used for password reset.') + '</span><br/><br/>')
            .append('<span>' + gt('Current Email address:') + '</span><span id="currentsecondary" style="padding-left:20px;"></span>');
        var emailTable = $('<table/>')
            .append('<tr><td><span>' + gt('Enter current Guard security password') + ': </span></td><td><input type="password" name="ogpass" /><td></tr>')
            .append('<tr><td><span>' + gt('Enter new secondary Email address') + ': </span></td><td><input name="newemail"/><td></tr>');
        var errorDiv = $('<div id="newemailerror" class="alert alert-info" style="display:none"/>');
        var emailButton = $('<button type="button" class="btn btn-primary">' + gt('Change Email address') + '</button>');

        emailButton.click(emailChanged);
        return (emailheader.append(emailTable).append(errorDiv).append(emailButton));
    }

    function updateEmail () {
        og_http.get(ox.apiRoot + '/oxguard/login?action=secondary', '&session=' + ox.session + '&userid=' + ox.user_id + '&cid=' + ox.context_id)
        .done(function (d) {
            d = d.trim();
            if (d.length < 2) {
                //#. No recovery email was given, so we will use the primary email address when resetting
                $('#currentsecondary').html(gt('None - Primary Email will be used'));
            } else {
                $('#currentsecondary').html(d);
            }
        });
    }

    function emailChanged () {
        var email = $('input[name="newemail"]').val();
        if (!validateEmail(email)) {
            $('#newemailerror').html(gt('Invalid email address'));
            $('#newemailerror').focus();
            showError('newemailerror');
        } else {
            var data = {
                userid: ox.user_id,
                cid: ox.context_id,
                email: email,
                password: $('input[name="ogpass"]').val()
            };
            $.post(ox.apiRoot + '/oxguard/login?action=changesecondary&session=' + ox.session, JSON.stringify(data), function () {
                $('#newemailerror').html(gt('Changed'));
                showError('newemailerror');
                updateEmail();
                $('input[name="ogpass"]').val('');
                $('input[name="newemail"]').val('');
            })
            .fail(function (d) {
                if (d.responseText.trim() === 'Bad password') {
                    $('#newemailerror').html(gt('Bad Password'));
                    showError('newemailerror');
                    if (!_.device('ios')) {
                        $('input[name="ogpass"]').focus();
                    }
                }
            });
        }
    }

    function showError(id) {
        $('#' + id).show();
        window.setTimeout(function () {
            $('#' + id).hide();
        }, 10000);
    }

    function validateEmail(email) {
        var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }

    function doReset() {
        require(['io.ox/core/api/account'], function (api) {
            api.getPrimaryAddress().done(function (data) {// Get primary address as backup
                var primaryEmail = data[1];
                var waitdiv = $('<div class="og_wait" id="keygen"></div');
                waitdiv.append('<i class="fa-key icon-key fa fa-spin icon-spin"/><span>' + gt('Generating key, Please wait') + '</span>');
                $('.window-container-center').append(waitdiv);
                waitdiv.show();
                var param = '&session=' + ox.session + '&userid=' + ox.user_id + '&cid=' + ox.context_id +
                '&default=' + encodeURIComponent(primaryEmail) + '&lang=' + ox.language;
                og_http.get(ox.apiRoot + '/oxguard/login?action=reset', param)
                .done(function (data) {
                    $('.og_wait').remove();
                    require(['io.ox/core/notifications'], function (notify) {
                        if (data.indexOf('primary') >= 0) {
                            notify.yell('success', gt('A new password has been sent to your email address'));
                            window.oxguarddata.passcode = 'Password Needed';
                            return;
                        }
                        if (data.indexOf('ok') >= 0) {
                            notify.yell('success', gt('A new password has been sent to your secondary email address'));
                            window.oxguarddata.passcode = 'Password Needed';
                            return;
                        }
                        if (data.trim() === 'NoRecovery') {
                            notify.yell('error', gt('No password recovery is available'));
                            return;
                        }
                        if (data.indexOf('FailNotify') >= 0) {
                            notify.yell('error', gt('Password reset, but unable to send to your email address'));
                            return;
                        }
                        if (data.indexOf('NoSecondary') >= 0) {
                            notify.yell('error', gt('Unable to find email address to send password reset'));
                            return;
                        }
                        notify.yell('error', gt('Unable to reset your password'));
                    });
                })
                .fail(function () {
                    $('.og_wait').remove();
                    require(['io.ox/core/notifications'], function (notify) {
                        notify.yell('error', gt('Unable to reset your password'));
                    });
                });
            });
        });
    }

    function passChanged() {

        var newpass = $('input[name="newpass1"]');
        var newpass2 = $('input[name="newpass2"]');
        var min = window.oxguarddata.settings.min_password_length;
        if (min !== undefined) {
            if (newpass.val().length < min) {
                $('#grdsettingerror').text(gt('New password must be at least %s characters long', min));
                $('#grdsettingerror').show();
                if (!_.device('ios')) {
                    newpass.focus();
                }
                return;
            }
        }
        if (newpass.val() !== newpass2.val()) {
            newpass2.css('background-color', 'salmon');
            return;
        } else {
            newpass2.css('background-color', 'white');
            var userdata = {
                    newpass: newpass.val(),
                    oldpass: $('input[name="oldpass"]').val().trim(),
                    user_id: ox.user_id,
                    sessionID: ox.session,
                    cid: ox.context_id,
                    user: ox.user
                };
            var waitdiv = $('<div class="og_wait" id="keygen"></div');
            waitdiv.append('<i class="fa-key icon-key fa fa-spin icon-spin"/><span>' + gt('Generating key, Please wait') + '</span>');
            $('.window-container-center').append(waitdiv);
            waitdiv.show();
            $.post(ox.apiRoot + '/oxguard/login?action=changepass&session=' + ox.session, JSON.stringify(userdata), function (data) {
                $('.og_wait').remove();
                if (typeof data === 'string') data = $.parseJSON(data);
                if (data.auth === 'Bad password') {
                    $('#grdsettingerror').text(gt('Bad password'));
                }
                if (data.auth === 'Lockout') {
                    $('#grdsettingerror').text(gt('Temporary Lockout'));
                }
                if (data.auth === 'Bad new password') {
                    $('#grdsettingerror').text(gt('New password must be at least %s characters long', data.minlength));
                }
                if (data.auth.length > 20) {
                    $('input[name="newpass1"]').val('');
                    $('input[name="newpass2"]').val('');
                    $('input[name="oldpass"]').val('');
                    window.oxguarddata.passcode = null;
                    window.oxguarddata.recovery = data.recovery;
                    redraw();
                    $('#grdsettingerror').text(gt('Success'));
                }
                $('#grdsettingerror').show();
                window.setTimeout(function () {
                    $('#grdsettingerror').hide();
                }, 10000);
            })
            .fail(function (e) {
                $('.og_wait').remove();
                var error = gt('Failed to change password');
                if (e.responseText.trim() === 'Bad Password') {
                    error = gt('Bad password');
                }
                $('#grdsettingerror').text(error);
                $('#grdsettingerror').show();
            });
            return;
        }
    }

    ext.point('oxguard/settings/detail').extend({
        index: 100,
        id: 'oxguardsettings',
        draw: function () {
            var node = this;
            draw (node);
        },
        save: function () {
        }
    });

    function draw (node) {
        $(node).empty();
        util.hasSetupDone()
        .done(function () {
            if (settings.get('cryptoProvider') === 'mailvelope') {
                require(['mailvelope/settings/pane'], function (mSettings) {
                    mSettings.drawMailvelopeSettings(node);
                });
                return;
            }
            node.append(addSettings());
        })
        .fail (function () {
            node.append(setupGuard(node));
            return;
        });

    }

    // Redraw
    function redraw () {
        $('#guard_settings').replaceWith(addSettings());
    }

    function addSettings () {
        var holder = $('<div id="guard_settings">').css('max-width', '800px');
        var message = $('<span>').append(gt('Guard Security Settings'));
        message.append(new HelpView({
            base: 'help-guard',
            iconClass: 'guardhelp',
            href: 'ox.guard.user.sect.settings.security.html',
            tabindex: '-1'
        }).render().$el);
        var header = $('<h1>').append(message);
        holder.append(header);
        return (holder.append(createPasswordChange()).append(createPasswordReset()).append(createSecondaryChange()).append(createDeleteRecovery()));
    }
});
