define('oxguard/settings/defaults', [
    'mailvelope/main',
    'io.ox/core/capabilities'
], function (api, capabilities) {
    'use strict';

    var guardSetUp = window.oxguarddata && window.oxguarddata.passcode === 'No key';

    function getDefault () {
        if (!api.isMailvelopeSupported()) {
            return 'guard';
        } else if (!capabilities.has('guard') || (capabilities.has('forceMailvelope') && !guardSetUp)) {
            // We only force Mailvelope if Guard not yet set up
            return 'mailvelope';
        }
    }

    return {
        cryptoProvider: getDefault()
    };
});
