/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/register', [
    'io.ox/core/extensions',
    'oxguard/oxguard_core',
    'gettext!oxguard',
    'settings!oxguard',
    'less!oxguard/style'
], function (ext, oxguard, gt, settings) {
    'use strict';

    var oxguarddata = {
        passcode: null,
        settings:  {},
        version: '2.2.1-rc3'
    };
    window.oxguarddata = oxguarddata;

    // Login section
    sendauth(''); // initial login, no password yet

    function sendauth(pass) {
        oxguard.auth(ox.user_id, pass)
        .done(function (data) {
            try {
                oxguarddata = _.extend(window.oxguarddata, data);
                if (data.auth.length > 20) {// If good code comes back, then store userid
                    oxguarddata.userid = ox.user_id;
                    oxguarddata.passcode = data.auth;
                    $('.og_signout').show();
                } else {// If bad code, then log and mark oxguard.user_id as -1
                    if ((data.auth.indexOf('Bad') > -1) || (data.auth.indexOf('Lockout') > -1)) {
                        oxguarddata.passcode = null;
                    } else {
                        oxguarddata.passcode = data.auth;
                    }
                    if (data.auth !== 'No Key') {
                        if (settings.get('cryptoProvider') === undefined) {
                            settings.set('cryptoProvider', 'guard').save();
                        }
                    }
                    oxguarddata.userid = -1;
                }
                if (ox.context_id === 0) ox.context_id = data.cid; // If the cid wasn't loaded, update from backend
                oxguarddata.baton = window.oxguarddata.baton;
                oxguarddata.recovery = data.recoveryAvail;
                window.oxguarddata = oxguarddata;

                if (sessionStorage !== null) {// If we were passed login info from login screen
                    try {
                        if (sessionStorage.oxguard && (sessionStorage.oxguard !== 'null')) {
                            var p = sessionStorage.oxguard;
                            sessionStorage.oxguard = null;
                            sendauth(p);
                        }
                    } catch (e) {
                        console.log('Private mode');
                        return;
                    }
                }
            } catch (e) {
                console.log(e);
                console.debug('Unable to connect to the encryption server');
            }
        })
        .fail(function () {
            $('.og_signout').hide();
            console.debug('Unable to connect to the encryption server');
        });
    }

    ext.point('io.ox/core/logout').extend({
        id: 'logoutOG',
        logout: function () {
            // force save requests for all pending settings
            var params = '&userid=' + ox.user_id + '&cid=' + ox.context_id;
            $.get(ox.apiRoot + '/oxguard/login?action=logout' + params, function () {
                window.oxguarddata = null;
            })
            .fail(function () {
                console.log('Fail logout oxguard');
            });
        }
    });

    ext.point('io.ox/core/topbar/right/dropdown').extend({
        id: 'guard-guided-tour',
        index: 260,
        draw: function () {
            this.append(
                $('<li class="og_tour">').append(
                    $('<a href="#" data-action="guard-tour" role="menuitem" tabindex="1">').text(gt('Guided tour for Guard'))
                )
                .on('click', function (e) {
                    e.preventDefault();
                    require(['io.ox/core/tk/wizard', 'oxguard/tour/main'], function (Tour) {
                        Tour.registry.run('default/oxguard');
                    });
                })
            );
        }
    });

    ext.point('io.ox/core/topbar/right/dropdown').extend({
        id: 'logoutOG',
        index: 990,
        draw: function () {
            this.append(
                $('<li class="divider og_signout" aria-hidden="true" role="presentation"></li>'),
                $('<li class="og_signout">').append(
                    $('<a href="#" data-action="logout" role="menuitem" tabindex="1">').text(gt('Sign out Guard'))
                )
                .on('click', function (e) {
                    e.preventDefault();
                    window.oxguarddata.passcode = null;
                    $('.og_signout').hide();
                })
            );
            var auth = window.oxguarddata.passcode;
            if (auth === null || auth === undefined) {
                hideLogout();
                return;
            }
            if (auth.length < 20) hideLogout();
        }
    });

    function hideLogout() {
        window.setTimeout(function () {
            $('.og_signout').hide();
        },100);
    }

});
