/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/pgp/settings', [
    'io.ox/core/extensions',
    'io.ox/core/folder/api',
    'gettext!oxguard',
    'settings!oxguard'
], function (ext, folderAPI, gt, settings) {
    'use strict';

    var point = ext.point('io.ox/settings/pane/main/oxguard');

    settings.on('change:cryptoProvider', updateExtensions);

    function updateExtensions (m, provider) {
        if (provider !== 'guard') {
            point.disable('oxguard/pgp');
        } else {
            point.enable('oxguard/pgp');
        }
    }

    function initAdvancedSettings() {
        var provider = settings.get('cryptoProvider');

        point.extend({
            title: gt('Guard PGP Settings'),
            id: 'oxguard/pgp',
            loadSettingPane: true,
            index: 100
        });

        updateExtensions(settings, provider);
    }

    initAdvancedSettings();

});
